
#include "Clustering.h"
#include "Global.h"
#include "Swarm.h"
// implementation of Clustering class
Cluster::Cluster():initial_numbers(0){
	numbers=0;
	group=0;
	dis=0;
}
Cluster::Cluster(CParticle *p, const int num):initial_numbers(num){
	numbers=num;
	group=new Group[numbers];
	for(int i=0;i<numbers;i++)
		group[i].Initial(p[i],i);
	dis=new double*[initial_numbers];
	for(int i=0;i<initial_numbers;i++)
		dis[i]=new double[initial_numbers];
	Calculate_Dis_Matrix();
}
void Cluster::Initial( CParticle *p,const int num){
	Clear();

	initial_numbers=num;
	numbers=num;
	group=new Group[numbers];
	for(int i=0;i<numbers;i++)
		group[i].Initial(p[i],i);
	dis=new double*[initial_numbers];
	for(int i=0;i<initial_numbers;i++)
		dis[i]=new double[initial_numbers];
	Calculate_Dis_Matrix();
}
void Cluster::Initial(const Cluster &clst){
	if(clst.initial_numbers==0) return;

	initial_numbers=clst.initial_numbers;
	numbers=clst.numbers;
	group=new Group[numbers];
	for(int i=0;i<numbers;i++)
		group[i].Initial(clst.group[i]);
	dis=new double*[initial_numbers];
	for(int i=0;i<initial_numbers;i++)
		dis[i]=new double[initial_numbers];
	for(int i=0;i<initial_numbers;i++)
		for(int j=0;j<initial_numbers;j++)
			dis[i][j]=clst.dis[i][j];
}
Cluster::~Cluster(){
	Clear();
}
void Cluster::Calculate_Dis_Matrix(){
	// only called by constructor
	for(int i=0;i<initial_numbers;i++){
		dis[i][i]=-1; //infinite great
		for(int j=0;j<i;j++)
			dis[i][j]=dis[j][i]=group[i].center.Distance(group[j].center);
	}

}
void Cluster::Refine_Clustering(){
	while(1){
		int i=0;
		while(i<numbers&&group[i].numbers>1) i++;
		if(i==numbers) break;
		int g1,g2;
		if(!Nearest_Group(g1,g2,1)) break;
		group[g2].Merge(group[g1]);
		Delete_Group(g1);
	}
	for(int i=0;i<numbers;i++) group[i].Calculate_Radius();
}
void Cluster::Rough_Clustering(){
	while(1){
		int i=0;
		while(i<numbers&&group[i].numbers>1) i++;
		if(i==numbers) break;
		int g1,g2;
		if(!Nearest_Group(g1,g2,0)) break;
		group[g2].Merge(group[g1]);
		Delete_Group(g1);
	}
	for(int i=0;i<numbers;i++) group[i].Calculate_Radius();
}
void Cluster::Delete_Group(const int id){
	int num=numbers-1;
	if(num<1){
		Clear();
		return;
	}
	Group *g=new Group[num];
	for(int i=0,j=0;i<num;i++,j++){
		if(j!=id){ 
			g[i].Initial(group[j].numbers,i);
			g[i]=group[j];
		}else
			i--;
	}
	delete [] group;
	group=g;
	numbers--;
}

double Cluster::Group_Dis(const int from,const int to){
	double dist;
	dist=sqrt((Global::boundary.upper-Global::boundary.lower)*(Global::boundary.upper-Global::boundary.lower)*Global::num_dim);
	for(int j=0;j<group[from].numbers;j++){
		for(int i=0;i<group[to].numbers;i++)
			if(dist>dis[group[from].members[j].index][group[to].members[i].index])
				dist=dis[group[from].members[j].index][group[to].members[i].index];
	}
	return dist;
	//return dis[group[from].center.index][group[to].center.index];
}
bool Cluster::Nearest_Group(int & g1, int & g2,bool flag){
	double Min_dis,dist;
	if(numbers==1) {
	 g1=0;
	 g2=0;
	 return false;
	}
	bool flag_fail=true;

	Min_dis=sqrt((Global::boundary.upper-Global::boundary.lower)*(Global::boundary.upper-Global::boundary.lower)*Global::num_dim);
	
	if(flag==1){// Refinement clustering
		for(int i=0;i<numbers;i++){
			for(int j=0;j<numbers;j++){
				if(j==i) continue;
				if(group[i].numbers>=CSwarm::max_local_popsize&&group[j].numbers>=CSwarm::max_local_popsize) continue;
				dist=Group_Dis(i,j);
				if(group[j].numbers>1&&group[i].numbers>1){
					if(dist/2>(group[i].radius>group[j].radius?group[i].radius:group[j].radius)) continue;
					//if(dist>(group[i].radius+group[j].radius)) continue;
				}else if(group[j].numbers>1&&group[i].numbers==1){
					if(dist/2>group[j].radius) continue;	
				}else if(group[j].numbers==1&&group[i].numbers>1){
					if(dist/2>group[i].radius) continue;	
				}else{
					int c=0;
					double d=0;
					for(int k=0;k<numbers;k++){
						if(group[k].numbers>1) {
							c++;
							if(d<group[k].radius)
								d=group[k].radius;
						}
					}
					if(c>0){
						//d=d/c;
						if(dist/2>d*2.0) continue;
					}
				}

				if(Min_dis>dist){
						Min_dis=dist;
						g1=i;
						g2=j;
					   flag_fail=false;
				}
				
			}
		}
	}else{// Rough Clustering
		for(int i=0;i<numbers;i++){
			//if(group[i].numbers>1) continue;// can't merge two groups whose numbers are both greater than 1
			for(int j=0;j<numbers;j++){
					if(j==i) continue;
					if(group[i].numbers>=CSwarm::max_local_popsize&&group[j].numbers>=CSwarm::max_local_popsize) continue;
					dist=Group_Dis(i,j);
					if(Min_dis>dist){
						Min_dis=dist;
						g1=i;
						g2=j;
						flag_fail=false;
					}			
			}
		}
	}
	if(flag_fail) return false;
	else return true;
}
void Cluster::Clear(){
	if(numbers>0){
		delete [] group;
		for(int i=0;i<initial_numbers;i++)
			delete [] dis[i];
		delete[] dis;
		numbers=0;
		initial_numbers=0;
	}	
}
Cluster &Cluster::operator =(const Cluster &clst){
	if(clst.initial_numbers==0) return *this;
	Clear();
	Initial(clst);	
	return *this;
}


