// Clustering.h

#pragma once
#include "Particle.h"
#include "Position.h"
#include "Group.h"

class Cluster{
public:
	Group *group;
	int numbers;
	int initial_numbers;
	double **dis;
public:
	Cluster();
	Cluster( CParticle *p,const int num);
	void Initial(const Cluster &clst);
	void Initial( CParticle *p,const int num);
	~Cluster();
	void Clear();
	Cluster &operator =(const Cluster &clst);
	void Calculate_Dis_Matrix();
	void Refine_Clustering();
	void Rough_Clustering();
	double Group_Dis(const int from,const int to);
	bool Nearest_Group(int & g1, int & g2,bool flag);
	void Delete_Group(const int id);

};


