//Global.cpp
#include "Global.h"


int Global::num_dim;
Cauchy Global::cauchy;
Normal Global::normal;
Uniform Global::uniform;
Boundary Global::boundary;
double Global::chaotic_constant;
Compare Global::optimization_type;
int Global::change_frequency=5000;
int Global::num_change=100;
int Global::T_Fes;
int Global::num_clusters=2;
double Global::sigma=0.00001;
int Global::num_start_clustering;
int Global::alg_found_peaks=0;
int Global::clst_num_peaks=0;
int Global::alg_real_peaks=0;

void Initialize_RandomArray(int * a,const int &dim){
	int * temp=new int[dim];
	for(int i=0;i<dim;i++)	temp[i]=i;
	int d=dim;
	for(int i=0;i<dim;i++){
		int t= (int)(d*Global::uniform.Next());
		a[i]=temp[t];
		for(int k=t;k<d-1;k++)
			temp[k]=temp[k+1];
		d--;
	}
	delete []temp;
}

int Sign(const double x){
	if(x>0) return 1;
	else if(x<0) return -1;
	else return 0;
}
void  Random_Weight(double *a, const int num){
	double sum=0;
	for(int i=0;i<num;i++){
		a[i]=Global::uniform.Next();
		sum+=a[i];
	}
	for(int i=0;i<num;i++){
		a[i]/=sum;
	}
}
void Update_Fit_Set(int i, int g, double **fit,double**relative,double best, double global_best){
	fit[i][g]+=best;
	if(Global::optimization_type==MIN)
		relative[i][g]+=global_best/best;
	else
		relative[i][g]+=best/global_best;

}
/* this function produces normally distributed random values */ 
double movnrand() 
{ static int backup=0;
  static double x2;
  double x1, w;
 
  if (backup){
    backup = 0;
    return (x2);
  }  else {
    do
	{ x1 = 2.0 * Global::uniform.Next() - 1.0;
      x2 = 2.0 * Global::uniform.Next() - 1.0;
      w = x1*x1 + x2*x2;
    } while ( w>=1.0 );
    w = sqrt( (-2.0*log(w) ) / w );
    x2 = w*x2;
    backup = 1;
    return (x1*w);
  }
}


