//Global.h
#pragma once

#include "newran.h"

#include<stdlib.h>
#include<time.h>
#include<math.h>
#include <assert.h>
#include <fstream>

#define PI 3.14159265358979323846
#define E 2.71828182845904523536
#define Num_Change_Type 6
#define Num_Run 50

//***********************Enviroment change types in GDBG system ******************************//
enum Change_type{small_step=0, large_step,u_random,recurrent,chaotic,recurrent_noisy};
//********************* Basic component funtion used in composition DBG **********************//
enum Fun_Name{Sphere=0,Rastrigin,Weierstrass,Griewank,Ackley};
//************** flag of minimization or maximization problem used in real space *************//
enum Compare{MIN=0,MAX};


class General_DBG;

struct Change_Type{
	Change_type type;
	int counter;
};
struct Boundary{						//***************************************************//
double upper;							//Dimension boudary in the landscape
double lower;							//**************************************************//
public:
	void Set_Boundary(const double l, const double u){
		lower=l;
		upper=u;
	};
	Boundary & operator=(const Boundary &b){
		if(this==&b) return *this;
		upper=b.upper;
		lower=b.lower;
		return *this;
	};
};

class Global{							
public:													//global class : save global variables
	static int num_dim;									// number  of dimensions
	static Cauchy cauchy;								// cauchy random number
	static Normal normal;								// gaussian random number
	static Uniform uniform;								// random number of uniform distribution
	static Boundary boundary;							// search range 
	static double chaotic_constant;						// parameter for chaotic system, between(1,4)
	static int change_frequency;						// number of evaluations between two successive changes
	static Compare optimization_type;					// minimization or maximization optimization problem
	static int num_change;								// the number of changes
	static const int sample_frequency=100;				// frequency of sampling test points during one change
	static int T_Fes;
	static int num_clusters;
	static int num_start_clustering;
	static double sigma;
	static int alg_found_peaks;
	static int clst_num_peaks;
	static int alg_real_peaks;

};

void Initialize_RandomArray(int * a,const int &dim);	// generate a set of radom numbers from 0-|a| without repeat
double Standard_Change(const Change_type,const double min, const double max);
int Sign(const double x);
void  Random_Weight(double *a, const int num);
void Update_Fit_Set(int i, int g, double **fit,double**relative,double best, double global_best);
double movnrand();

inline double Chaotic_Value(const double x, const double min, const double max){
														// return a value calculated by logistics function 
	if(min>max) return -1;
	double chaotic_value;
	chaotic_value=(x-min)/(max-min);
	chaotic_value=Global::chaotic_constant*chaotic_value*(1-chaotic_value);
	return min+chaotic_value*(max-min);
}


template <class T>
void Copy(T* destination, const T* source,const int & dim){
														//copy function 
	if(destination==source) return;
	for(int i=0;i<dim;i++)
		destination[i]=source[i];
}

template <class T>							
T Extremum(T * v,const int & size,const Compare & type){
														// return min or max value of set V
	
	T extreme;
	extreme=v[0];
	int index=0;
	if(type==MAX){ 
		for(int i=1;i<size;i++){
			if(v[i]>extreme) {
					extreme=v[i];
					index=i;
				}
		}
	}
	else if(type==MIN){
		for(int i=1;i<size;i++){
				if(v[i]<extreme) {
						extreme=v[i];
						index=i;
					}
			}
	}
	return extreme;
}

void inline Random_Sum_One(double *p,const double min,const double max,const int n){
	double l,h;
	double sum=0;
	for(int i=0;i<n-1;i++){
		l=min-sum<=min?min:min-sum;
		h=max-sum>=max?max:max-sum;
		p[i]=l+(h-l)*Global::uniform.Next();
		sum+=p[i];
	}
	p[n-1]=1-sum;
}
template <class T>
int Partition(int low,int high,T arr[])
{ 
	T high_vac,low_vac,pivot;
	pivot=arr[low];
	while(high>low){ 
		high_vac=arr[high];

		while(pivot<=high_vac){
			if(high<=low) break;
			high--;
			high_vac=arr[high];
		}

		arr[low]=high_vac;
		low_vac=arr[low];
		while(pivot>=low_vac){
			if(high<=low) break;
			low++;
			low_vac=arr[low];
		}
		arr[high]=low_vac;
	}
	arr[low]=pivot;

	return low;
}
template <class T>
void Quick_sort(int low,int high,T arr[])
{
  int Piv_index;
  if(low<high){
   Piv_index=Partition(low,high,arr);
   Quick_sort(low,Piv_index-1,arr);
   Quick_sort(Piv_index+1,high,arr);
  }
}
