

#include "Group.h"
#include "Global.h"

// implementation of Group class
Group::Group(){

}

Group::Group(const int num){
numbers=num;
members=new CParticle[numbers];
}
Group::~Group(){
delete [] members;
numbers=0;
}
void Group::Initial(const CParticle &p,const int id){
	numbers=1;
	members=new CParticle[numbers];
	members[0]=p; 
	center=p.pbest;
	best=p.pbest;
	ID=id;
	radius=0;
}
void Group::Initial(const int num,const int id){
	numbers=num;
	members=new CParticle[numbers];
	ID=id;
}
void Group::Initial(const Group &g ){
	numbers=g.numbers;
	members=new CParticle[numbers];
	for(int i=0;i<numbers;i++)
		members[i]=g.members[i];
	center=g.center;
	ID=g.ID;
	best=g.best;
	radius=g.radius;
}
void Group::Merge(const Group &g){
	
	int t_num=numbers+g.numbers;
	CParticle *t_mem=new CParticle[t_num];
	for(int i=0;i<numbers;i++)
		t_mem[i]=members[i];
	for(int i=0;i<g.numbers;i++)
		t_mem[i+numbers]=g.members[i];
	numbers=t_num;
	delete[] members;
	members=t_mem;
	if(!best.Better(g.best)) best=g.best;
	ID=ID<g.ID?ID:g.ID;
	Calculate_Radius();
}
void Group::Calculate_Radius(){

	radius=0;
	if(numbers<2) return;
	double *t=new double[Global::num_dim];
	for(int i=0;i<Global::num_dim;i++)
		t[i]=0;
	for(int i=0;i<Global::num_dim;i++){
		for(int j=0;j<numbers;j++)
			t[i]+=members[j].pbest.x[i];
		t[i]/=numbers;
	}
	Copy(center.x,t,Global::num_dim);
	center.Fun_Obj();
	if(center.Better(best)) best=center;

	for(int j=0;j<numbers;j++)
		radius+=members[j].pbest.Distance(t);
	radius=radius/numbers;
	delete [] t;
		//if(members[i].ID!=center.ID) radius+=center.pbest.Distance(members[i].pbest);
	//radius=radius/(numbers-1);
}
bool Group::operator ==(const Group &g){

	if(numbers!=g.numbers) return false;
	for(int i=0;i<numbers;i++){
		int j=0;
		while(j<numbers&&members[i].ID!=g.members[j].ID)j++;
		if(j==numbers) return false;

	}
	return true;
}
Group &Group::operator =(const Group &g){

	if(this==&g) return *this;
	if(numbers!=g.numbers) return *this;
	Copy(members,g.members,numbers);
	center=g.center;
	radius=g.radius;
	best=g.best;
	ID=g.ID;
	return *this;
}
