// Local_Optima.h
#pragma once
#include "Position.h"
#include "Global.h"

struct Local_Optimum{
CPosition location;
double radius;
bool clustering_done;
public:
	Local_Optimum(){
	radius=0;
	clustering_done=false;
	}
	Local_Optimum &operator =(const Local_Optimum & l){
	if(this==&l) return *this;
	location=l.location;
	radius=l.radius;
	clustering_done=l.clustering_done;
	return *this;
	}
};

class Local_Optima{
public:
	Local_Optimum *optima;
	int numbers;
public:
	Local_Optima(){
		numbers=0;
		optima=0;
	};
	Local_Optima(const int num){
		numbers=num;
		optima=new Local_Optimum[numbers];
	}
	~Local_Optima(){
		Clear();
	};
	void Alocate_Memory(const int num){
		if(num<1) {
			cout<<"error! in Alocate_Memory of Local_Optima"<<endl;
			system(0);
		}
		numbers=num;
		optima=new Local_Optimum[numbers];
	}
	void Clear(){
		if(numbers>0) {
			delete [] optima;
			optima=0;
		}
		numbers=0;
	}
	Local_Optima & operator+(const Local_Optimum & l){
		Local_Optima *lo=new Local_Optima[numbers+1];
		lo->Alocate_Memory(numbers+1);
		for(int i=0;i<numbers;i++){
			lo->optima[i]=optima[i];
		}
		lo->optima[numbers]=l;
		return *lo;
	}
	Local_Optima & operator+(const Local_Optima &l){
		Local_Optima *lo=new Local_Optima[numbers+l.numbers];
		lo->Alocate_Memory(numbers+l.numbers);
		int i;
		for( i=0;i<numbers;i++)
			lo->optima[i]=optima[i];
		
		for(int j=0;j<l.numbers;j++,i++){
			lo->optima[i]=l.optima[j];
		}
		return *lo;
	}
	Local_Optima & operator=(const Local_Optima &l){
		if(this==&l) return *this;
		int num=l.numbers;
		Local_Optimum *lo=new Local_Optimum[l.numbers];
		int i;
		for( i=0;i<l.numbers;i++)
			lo[i]=l.optima[i];
		Clear();
		optima=lo;
		numbers=num;
		return *this;
	}
	void  Delete_Optimum(const int index){
		if(numbers<2){
			Clear();
			return;
		}
		Local_Optima *lo=new Local_Optima[numbers-1];
		lo->Alocate_Memory(numbers-1);
		for(int i=0,j=0;i<numbers;i++,j++){
			if(i!=index)
			lo->optima[j]=optima[i];
			else
				j--;
		}
		Clear();
		optima=lo->optima;
		numbers=lo->numbers;
	}
	void Update_Fitness(){
		for(int i=0;i<numbers;i++)	optima[i].location.Fun_Obj();	
	}
	const Local_Optimum & Find_Best(){
		//assert(numbers<1);
		int index=0;
		double best_fit=optima[0].location.fitness;
		for(int i=1;i<numbers;i++)
			if(optima[i].location.Better(best_fit)){
				best_fit=optima[i].location.fitness;
				index=i;
			}
		return optima[index];
	}
};
