#pragma once

#include "Position.h"

/***** Moving Peak Benchmark*****/
class MovingPeak{
public:
	static int F;
	static double vlength ; /* distance by which the peaks are moved, severity */
	static double height_severity; /* severity of height changes, larger numbers  mean larger severity */
	static double width_severity; /* severity of width changes, larger numbers mean larger severity */

	/* lambda determines whether there is a direction of the movement, or whether
	   they are totally random. For lambda = 1.0 each move has the same direction,
	   while for lambda = 0.0, each move has a random direction */
	static double lambda;
	static int number_of_peaks; /* number of peaks in the landscape */
	static int use_basis_function; /* if set to 1, a static landscape (basis_function) is included in the fitness evaluation */
	static int calculate_average_error; /* saves computation time if not needed and set to 0 */
	static int calculate_offline_performance ; /* saves computation time if not needed and set to 0 */
	static int calculate_right_peak ; /* saves computation time if not needed and set to 0 */

	/* minimum and maximum height of the peaks          */
	/* height chosen randomly when standardheight = 0.0 */
	static double minheight , maxheight, standardheight;
	/* width chosen randomly when standardwidth = 0.0 */
	static double minwidth  , maxwidth , standardwidth; 
	//0.8 7.0
	static int recent_change ; /* indicates that a change has just ocurred */
	static int current_peak;      /* peak on which the current best individual is located */
	static int maximum_peak;       /* number of highest peak */
	static double current_maximum; /* fitness value of currently best individual */ 
	static double offline_performance ;
	static double offline_error ;
	static double avg_error;    /* average error so far */ 
	static double current_error;/* error of the currently best individual */
	static double global_max;     /* absolute maximum in the fitness landscape */
	static int evals ;         /* number of evaluations so far */
	static double **peak;         /* data structure to store peak data */
	static double *shift;
	static double *coordinates;
	static int *covered_peaks;    /* which peaks are covered by the population ? */
	static double **prev_movement;/* to store every peak's previous movement */

public:
	static double eval_movpeaks (double *gen);
	/* the following basis functions are provided :*/
	static double constant_basis_func(double *gen);
	static double five_peak_basis_func(double *gen);
	/* the following peak functions are provided: */
	static double peak_function1(double *gen, int peak_number);
	static double peak_function_cone (double *gen, int peak_number);
	static double peak_function_hilly (double *gen, int peak_number);
	static double peak_function_twin (double  *gen, int peak_number);
	static double function_selection(double  *gen, int peak_number);
	static void change_peaks();   /* preliminary declaration of function change_peaks()*/
	static double dummy_eval (double *gen); 
	static void offline_error_eval(CPosition &p);
	static void init_peaks();
	static void free_peaks();
	static void current_peak_calc (double *gen);
	static void change_stepsize_random () ;
	static void change_stepsize_linear();
	static double get_avg_error(); /* returns the average error of all evaluation calls so far */
	static double get_current_error(); /* returns the error of the best individual evaluated since last change */
		 /* To use this function, calculate_average_error and calculate_offline_performance must be set */
	static double get_offline_performance(); /* returns offline performance */
	static double get_offline_error();
	static int get_number_of_evals();
	static int get_right_peak();
};
