
#include "Particle.h"
#include "Global.h"
using namespace std;

CParticle::CParticle(){

	int d=Global::num_dim;
	
	vmax=new double[d];
	v=new double[d];
	for(int i=0;i<d;i++){
		vmax[i]=(Global::boundary.upper-Global::boundary.lower)/5;
	}
}
CParticle::~CParticle(){
	delete [] vmax;
	delete [] v;
}
void CParticle::Initialization(const int idex,const int id){
	int i;
	double u,l;
	
	for( i=0;i<Global::num_dim;i++){
		u=Global::boundary.upper;
		l=Global::boundary.lower;
		pself.x[i]=l+(u-l)*Global::uniform.Next();
		
		v[i]=(u-l)*(-0.5+Global::uniform.Next())/2;
	}
	pself.Fun_Obj();
	pbest=pself;
	ID=id;
	index=idex;
}
CParticle & CParticle::operator=(const CParticle &p){
	
	if(this==&p) return *this;
	pself=p.pself;
	index=p.index;
	ID=p.ID;
	pbest=p.pbest;
	Copy(v,p.v,Global::num_dim);
	Copy(vmax,p.vmax,Global::num_dim);
	return *this;
}
void CParticle::Initialization(const Local_Optimum &p,const int idex,const int id){
	
	
	pself=p.location;
	pself.Fun_Obj();
	pbest=pself;
	ID=id;
	index=idex;
	double u,l;
	for( int i=0;i<Global::num_dim;i++){
		u=Global::boundary.upper;
		l=Global::boundary.lower;
		v[i]=l+(u-l)*Global::uniform.Next()/2;
	}
}
void CParticle::Initialization(CPosition &p,double radius, const int idex,const int id){
	int i;
	double u,l;
	while(1){
		double r;
		r=radius>Global::sigma?radius:Global::sigma;
		for( i=0;i<Global::num_dim;i++){
			u=Global::boundary.upper;
			l=Global::boundary.lower;
			pself.x[i]=p.x[i]+r*Global::uniform.Next();
			
			v[i]=l+(u-l)*Global::uniform.Next()/2;
		}
		
		if(p.Distance(pself)<r) break;
	}
	pself.Fun_Obj();
	pbest=pself;
	ID=id;
	index=idex;
}
double CParticle::Velocity(){
	double velocity=0;
	for(int d=0;d<Global::num_dim;d++) velocity+=fabs(v[d]);
return velocity;
}

void CParticle::Print(ofstream &out){
	int i;
	//out<<"the position is:"<<endl;
	for( i=0;i<Global::num_dim;i++)
		out<<pself.x[i]<<" ";
	
	//out<<endl<<"the velocity is:"<<endl;
	//for( i=0;i<Global::num_dim;i++)
	//out<<v[i]<<" ";
	out<<endl;
}

void CParticle::PSO_Move(const double *lbest , const double *gbest,double w, double c1, double c2){
	
	double mincoordinate,maxcoordinate;
	double cur_x;

	for(int j=0;j<Global::num_dim;j++){
			mincoordinate=Global::boundary.lower;
			maxcoordinate=Global::boundary.upper;
			
			if(pself.x[j]==mincoordinate||pself.x[j]==maxcoordinate){
				double p=Global::uniform.Next();
				pself.x[j]=p*lbest[j]+(1-p)*gbest[j];
			}
			cur_x=pself.x[j];
			v[j]=w*v[j]+c1*Global::uniform.Next()*(lbest[j]-pself.x[j])+c2*Global::uniform.Next()*(gbest[j]-pself.x[j]);
				if(fabs(v[j])>vmax[j]) 
						v[j]=Sign(v[j])*vmax[j];
				pself.x[j]=pself.x[j]+v[j];
			
	
			if(pself.x[j]>maxcoordinate||pself.x[j]<mincoordinate){
				//pself.x[j]=Sign(pself.x[j])*maxcoordinate;
				pself.x[j]=cur_x+(Sign(cur_x)*maxcoordinate-cur_x)*Global::uniform.Next();
			} 
	}
	pself.Fun_Obj();
}


void CParticle::Repel_Move(const CPosition &lbest,const CPosition &nearest,const Local_Optima &converge_optima,const Local_Optima &non_converge_optima,double w, double c1, double c2){
	double mincoordinate,maxcoordinate;
	double cur_x;

	
	for(int j=0;j<Global::num_dim;j++){
			mincoordinate=Global::boundary.lower;
			maxcoordinate=Global::boundary.upper;
			
			if(pself.x[j]==mincoordinate||pself.x[j]==maxcoordinate){
				double p=Global::uniform.Next();
				pself.x[j]=p*lbest.x[j]+(1-p)*pself.x[j];
			}
			cur_x=pself.x[j];
			double belta=1;
			double v_r=0;
			if(converge_optima.numbers+non_converge_optima.numbers>0){
				belta=Global::uniform.Next()+0.5;
				for(int i=0;i<converge_optima.numbers;i++){
					double dis=pself.Distance(converge_optima.optima[i].location);
					if(dis==0) dis=0.00001;
			
					if(dis<converge_optima.optima[i].radius)
					v_r+=c2*Sign(pself.x[j]-converge_optima.optima[i].location.x[j])*converge_optima.optima[i].radius/dis;
				
				}
				for(int i=0;i<non_converge_optima.numbers;i++)
				{
					if(!non_converge_optima.optima[i].clustering_done) continue;
					double dis=pself.Distance(non_converge_optima.optima[i].location);
					if(dis==0) dis=0.00001;
					
					if(dis<non_converge_optima.optima[i].radius)
					v_r+=c2*Sign(pself.x[j]-non_converge_optima.optima[i].location.x[j])*non_converge_optima.optima[i].radius/dis;
				}
			}

			v[j]=w*v[j]+c1*Global::uniform.Next()*(lbest.x[j]-pself.x[j])+c1*Global::uniform.Next()*(nearest.x[j]-pself.x[j])+v_r;
			
			if(fabs(v[j])>vmax[j]) 
					v[j]=Sign(v[j])*vmax[j];
			pself.x[j]=pself.x[j]+v[j];
			
	
			if(pself.x[j]>maxcoordinate||pself.x[j]<mincoordinate){
				//pself.x[j]=Sign(pself.x[j])*maxcoordinate;
				pself.x[j]=cur_x+(Sign(cur_x)*maxcoordinate-cur_x)*Global::uniform.Next();
			} 
	}
	pself.Fun_Obj();
}
