
#include "Position.h"
#include "Global.h"
#include "MovingPeak.h"


CPosition::CPosition(){
	x=new double[Global::num_dim];
}
CPosition::CPosition(const int n){
	x=new double[n];
}
CPosition::~CPosition(){
	delete [] x;
}

CPosition & CPosition::operator=(const CPosition &p){
	if(this==&p) return *this;
	Copy(x,p.x,Global::num_dim);
	fitness=p.fitness;
	return *this;
}
void CPosition::Fun_Obj(){
	fitness=MovingPeak::eval_movpeaks(x);
}

void CPosition::Print(ofstream &out){
	int i;
	for( i=0;i<Global::num_dim;i++)
		out<<x[i]<<" ";
	out<<endl;
}
bool CPosition::Better(const CPosition &p){
	if(Global::optimization_type==MIN){
		if(fitness<p.fitness) return true;
		else return false;
	}
	else{
		if(fitness>p.fitness) return true;
		else return false;
	}
}
bool CPosition::Better(const double p){
	if(Global::optimization_type==MIN){
		if(fitness<p) return true;
		else return false;
	}
	else{
		if(fitness>p) return true;
		else return false;
	}
}

double CPosition::Distance(double *position){
	double d=0;
	for(int i=0;i<Global::num_dim;i++){
		d+=(x[i]-position[i])*(x[i]-position[i]);
	}
	return sqrt(d);
}
double CPosition::Distance(const CPosition &p){
	double d=0;
	for(int i=0;i<Global::num_dim;i++){
		d+=(x[i]-p.x[i])*(x[i]-p.x[i]);
	}
	return sqrt(d);
}

void CPosition::Cauchy_Mutation(){
	double mincoordinate,maxcoordinate;
	for(int j=0;j<Global::num_dim;j++){
			mincoordinate=Global::boundary.lower;
			maxcoordinate=Global::boundary.upper;
			//if(Global::uniform.Next()>1./(double)Global::num_dim) continue;
			double cur_x=x[j];				
			x[j]=x[j]+Global::normal.Next();
			if(x[j]>maxcoordinate||x[j]<mincoordinate){
				x[j]=cur_x;
			} 
	}
	Fun_Obj();
}


