
#include "Swarm.h"
#include "Global.h"
#include "Clustering.h"
#include <assert.h>

using namespace std;
CPosition *CSwarm::global_best=0;

int CSwarm::pop_num=0;
CSwarm *CSwarm::sub_swarm=0;

Local_Optima *CSwarm::non_converge_optima=0;
Local_Optima *CSwarm::converge_optima=0;
Local_Optima *CSwarm::pre_optima=0;

int CSwarm::global_popsize;
int CSwarm::min_local_popsize=3;
int CSwarm::max_local_popsize=5;

CSwarm::CSwarm(void){
	/*c1=c2=1.4960;
	max_w=0.7298f;
	min_w=0.40;   
	w=0.7298f;*/
	
	
	c1=c2=1.7;
	max_w=0.6f; 
	min_w=0.3;   
	w=0.6f;

	evo_num=0;
	pop=0;
	clst=0;
	popsize=0;
	max_ID=0;
	initial_radius=cur_radius=0;
	clustering_done=false;

}

CSwarm::CSwarm(const int pop_size){
	c1=c2=1.7;
	max_w=0.6f; 
	min_w=0.3;   
	w=0.6f;
	int i;
	popsize=pop_size;
	max_ID=popsize;
	pop= new CParticle[pop_size];
	for( i=0;i<pop_size;i++) pop[i].Initialization(i,i+1);
	Best=pop[Find_Best()].pself;
	clustering_done=false;
	Calculate_Center();
	Calculate_Initial_Radius();
	evo_num=0;
	clst=new Cluster [Global::num_clusters];
	
}
CSwarm::CSwarm(const Group &g){
	c1=c2=1.7;
	max_w=0.6f; 
	min_w=0.3;   
	w=0.6f;
	popsize=g.numbers;
	max_ID=popsize;
	pop=new CParticle[popsize];
	initial_radius=g.radius;
	for(int i=0;i<popsize;i++){
		pop[i]=g.members[i];
		pop[i].ID=i+1;
		pop[i].index=i;
	}
	clustering_done=false;
	evo_num=0;
	Best=pop[Find_PBest()].pbest;
	if(!Best.Better(g.center)) Best=g.center;
	Calculate_Center();
	Calculate_Initial_Radius();	
	clst=new Cluster [Global::num_clusters];
	
}
CSwarm::CSwarm(const CSwarm &s){
	Alocate_Memory(s.popsize);
	(*this)=s;
}
void CSwarm::Initial(const int pop_size){
	if(pop_size<1) return;
	int i;
	popsize=pop_size;
	max_ID=popsize;
	pop= new CParticle[pop_size];
	for( i=0;i<pop_size;i++) pop[i].Initialization(i,i+1);
	Best=pop[Find_Best()].pself;
	Calculate_Center();
	Calculate_Initial_Radius();

	clustering_done=false;
	evo_num=0;
	clst=new Cluster [Global::num_clusters];
}
void CSwarm::Alocate_Memory(const int pop_size){
	popsize=pop_size;
	pop= new CParticle[pop_size];
	clst=new Cluster [Global::num_clusters];
}
CSwarm &CSwarm::operator= (const CSwarm &s){
	if(this==&s) return *this;
	if(s.popsize==0){
		Clear();
		return *this;
	} 
	if(popsize!=s.popsize){
		Clear();
		Alocate_Memory(s.popsize);
	}
	int i;
	for( i=0;i<popsize;i++){
		pop[i]=s.pop[i];
	}
	for( int k=0;k<Global::num_clusters;k++) clst[k]=s.clst[k];
	max_ID=s.max_ID;
	Best=s.Best;
	Worst=s.Worst;	
	initial_radius=s.initial_radius;
	cur_radius=s.cur_radius;
	color=s.color;
	clustering_done=s.clustering_done;
	evo_num=s.evo_num;
	center=s.center;
	c1=s.c1;
	c2=s.c2;
	max_w=s.max_w;
	min_w=s.min_w;
	w=s.w;
	return *this;
}
CSwarm::~CSwarm(void){
	Clear();
	max_ID=0;
	if(clst){
		delete [] clst;
		clst=0;
	}
}
void CSwarm::Clear(){
	if(pop){
		delete [] pop;
		pop=0;
		popsize=0;
	}
	
}
const int CSwarm::Find_Best(void)const
{
	double temp=pop[0].pself.fitness;
	int index_best=0;
	
	for(int i=1;i<popsize;i++){
		if(pop[i].pself.Better(temp)){
			temp=pop[i].pself.fitness;
			index_best=i;
		}
	}
	
	return index_best;
}
const int CSwarm::Find_PBest(void)const{
	double temp=pop[0].pbest.fitness;
	int index_best=0;
	
	for(int i=1;i<popsize;i++){
		if(pop[i].pbest.Better(temp)){
			temp=pop[i].pbest.fitness;
			index_best=i;
		}
	}
	return index_best;
}
const int  CSwarm::Find_PWorst(void)const{
	double temp=pop[0].pbest.fitness;
	int index_best=0;
	for(int i=1;i<popsize;i++){
		if(!pop[i].pbest.Better(temp)){
			temp=pop[i].pbest.fitness;
			index_best=i;
		}
	}
	return index_best;
}
void CSwarm::Add_Particle(const CParticle &p){
	int old_size=popsize;
	CParticle *t_pop=new CParticle[popsize+1];
	for(int i=0;i<popsize;i++) t_pop[i]=pop[i];
	t_pop[popsize]=p;
	t_pop[popsize].index=popsize;
	t_pop[popsize].ID=max_ID+1;
	int pop_size=popsize+1;
	Clear();
	pop=t_pop;
	popsize=pop_size;
	max_ID++;
	if(old_size==0)
		Best=pop[Find_PBest()].pbest;
	else
		if(!Best.Better(pop[Find_PBest()].pbest)) Best=pop[Find_PBest()].pbest;

	Calculate_Center();
	Update_Cur_Radius();
	
}
void CSwarm::Add_Particle(const int num){
	if(num<1) return ;
	CParticle *t_pop=new CParticle[popsize+num];
	int old_size=popsize;
	for(int i=0;i<popsize;i++) t_pop[i]=pop[i];
	Local_Optima lo;
	lo=*CSwarm::non_converge_optima+*CSwarm::converge_optima;
	for(int i=0;i<num;i++){
		max_ID++;
		t_pop[popsize].Initialization(popsize,max_ID);
		int counter=0;
		while(counter<lo.numbers){
			int j;
			
			for( j=0;j<lo.numbers;j++){
				
				if(t_pop[popsize].pself.Distance(lo.optima[j].location)<lo.optima[j].radius){
				break;
				}
			}
			if(j==lo.numbers) break;
			
			t_pop[popsize].Initialization(popsize,max_ID);
			counter++;
		}
		popsize++;
	}
	int pop_size=popsize;
	Clear();
	pop=t_pop;
	popsize=pop_size;
	if(old_size==0)
		Best=pop[Find_PBest()].pbest;
	else
		if(!Best.Better(pop[Find_PBest()].pbest)) Best=pop[Find_PBest()].pbest;

	Calculate_Center();
	Update_Cur_Radius();
	
}
void CSwarm::Add_Particle(const Local_Optima &l){

	if(l.numbers<1) return;
	CParticle *t_pop=new CParticle[popsize+l.numbers];

	for(int i=0;i<popsize;i++) t_pop[i]=pop[i];
	
	for(int i=0;i<l.numbers;i++){
		max_ID++;
		t_pop[popsize].Initialization(l.optima[i],popsize,max_ID);
		popsize++;
	}
	int pop_size=popsize;
	Clear();
	pop=t_pop;
	popsize=pop_size;
	Best=pop[Find_PBest()].pbest;
	Calculate_Center();
	Update_Cur_Radius();

	
}
void CSwarm::Delete_Particle(const int id){
	if(popsize==1){
		Clear();
		max_ID=0;
		return ;
	}
	int old_size=popsize;
	CParticle *t_pop=new CParticle[popsize-1];
	for(int i=0,j=0;i<popsize;i++,j++){ 
		if(pop[i].ID!=id)	
		t_pop[j]=pop[i];
		else
			j--;
	}
	int pop_size=popsize-1;
	Clear();
	pop=t_pop;
	popsize=pop_size;
	Update_Index();
	if(old_size==0)
		Best=pop[Find_PBest()].pbest;
	else
		if(!Best.Better(pop[Find_PBest()].pbest)) Best=pop[Find_PBest()].pbest;

	Calculate_Center();
	Update_Cur_Radius();
	Update_MaxID();
		
}
void CSwarm::Delete_Particle(const int *id,const int num){
		assert(popsize>=num);
	if(popsize==num){
		Clear();
		max_ID=0;
		return ;
	}
	int old_size=popsize;
	CParticle *t_pop=new CParticle[popsize-num];
	for(int i=0,k=0;i<popsize;i++,k++){ 
		int j=0;
		while(j<num&&pop[i].ID!=id[j]) j++;
		if(j==num)	
		t_pop[k]=pop[i];
		else
			k--;
	}
	int pop_size=popsize-num;
	Clear();
	pop=t_pop;
	popsize=pop_size;
	Update_Index();
	if(old_size==0)
		Best=pop[Find_PBest()].pbest;
	else
		if(!Best.Better(pop[Find_PBest()].pbest)) Best=pop[Find_PBest()].pbest;

	Calculate_Center();
	Update_Cur_Radius();
	Update_MaxID();
}
void CSwarm::Over_Crowd_Check(){
	if(popsize<= CSwarm::max_local_popsize) return;
	for(int i=0;i<popsize;i++) pop[i].resp=0;
	int num=popsize-CSwarm::max_local_popsize;
	int *id=new int[num];
	for(int i=0;i<num;i++){
		int index,j=0;
		while(pop[j].resp!=0&& j<popsize)j++;
		index=j;
		double temp=pop[index].pbest.fitness;
		
		for(int j=index+1;j<popsize;j++){
			if(pop[j].resp==0&&!pop[j].pbest.Better(temp)){
				temp=pop[j].pbest.fitness;
				index=j;
			}
		}
		id[i]=pop[index].ID;
		pop[index].resp=1;
	}
	Delete_Particle(id,num);
	delete [] id;
}
void CSwarm::Add_Pop(CSwarm & w){
	CSwarm *sw=new CSwarm[pop_num+1];
	int i=0;
	for( i=0;i<pop_num;i++){
		sw[i].Alocate_Memory(sub_swarm[i].popsize);
		sw[i]=sub_swarm[i];
	}
	sw[i].Alocate_Memory(w.popsize);
	sw[i]=w;
	if(pop_num>0)	{
		delete [] sub_swarm;
		sub_swarm=0;
	}
	delete &w;
	sub_swarm= sw;

	pop_num++;

}
void CSwarm::Delete_Pop(int index){
	if(pop_num==1) {
		delete  [] sub_swarm;
		sub_swarm=0;
		pop_num--;
		return ;
	}
	CSwarm *sw=new CSwarm[pop_num-1];
	int i,j;
	for( i=0,j=0;j<pop_num;i++,j++){
		if(j==index){
			i--;
			continue;	
		}	
		sw[i].Alocate_Memory(sub_swarm[j].popsize);
		sw[i]=sub_swarm[j];
	}
	delete [] sub_swarm;
	pop_num--;
	sub_swarm=sw;
}
bool CSwarm::Overlap_NonCon_Check(){
	for(int i=0;i<pop_num;i++){
		//if(CSwarm::sub_swarm[i].clustering_done==false) continue;
		for(int j=i+1;j<pop_num;j++){
		//	if(CSwarm::sub_swarm[j].clustering_done==false) continue;
			double dist=CSwarm::sub_swarm[i].center.Distance(CSwarm::sub_swarm[j].center);

			if(dist<CSwarm::sub_swarm[i].initial_radius||dist<CSwarm::sub_swarm[j].initial_radius){
				
				int c1=0,c2=0;
				for(int k=0;k<CSwarm::sub_swarm[j].popsize;k++){
					dist=CSwarm::sub_swarm[i].center.Distance(CSwarm::sub_swarm[j].pop[k].pbest);
					if(dist<CSwarm::sub_swarm[i].initial_radius) c1++;
				}
					
				for(int k=0;k<CSwarm::sub_swarm[i].popsize;k++){
					dist=CSwarm::sub_swarm[j].center.Distance(CSwarm::sub_swarm[i].pop[k].pbest);
					if(dist<CSwarm::sub_swarm[i].initial_radius) c2++;
				}
				if(c1>CSwarm::sub_swarm[j].popsize*0.7&&c2>CSwarm::sub_swarm[i].popsize*0.7){
					if(CSwarm::sub_swarm[i].Best.Better(CSwarm::sub_swarm[j].Best)){
					CSwarm::sub_swarm[i].Add_Particle(CSwarm::sub_swarm[j]);
						CSwarm::Delete_Pop(j);
						CSwarm::non_converge_optima->Delete_Optimum(j);
					}else{
					CSwarm::sub_swarm[j].Add_Particle(CSwarm::sub_swarm[i]);
						CSwarm::Delete_Pop(i);
						CSwarm::non_converge_optima->Delete_Optimum(i);
					}
					return true;
				}
			}
		}
	}
	return false;
}

bool CSwarm::Check_Converge(){
	Update_Cur_Radius(0);
	if(cur_radius<=Global::sigma)	
		return true;
	else return false;
}
void CSwarm::Update_Cur_Radius(bool flag_pbest){
	cur_radius=0;
	if(popsize<2) return;
	double *t=new double[Global::num_dim];
	for(int i=0;i<Global::num_dim;i++)
		t[i]=0;
	for(int i=0;i<Global::num_dim;i++){
		for(int j=0;j<popsize;j++)
			t[i]+=pop[j].pbest.x[i];
		t[i]/=popsize;
	}
	if(flag_pbest){
		for(int j=0;j<popsize;j++)
			cur_radius+=pop[j].pbest.Distance(t);
	}else{
		for(int j=0;j<popsize;j++)
			cur_radius+=pop[j].pself.Distance(t);
	}
	cur_radius=cur_radius/popsize;
	delete [] t;
}


int CSwarm::Find_Nearest(int idx,bool pbest_to_pbest){
	int index;
	double Min_dis=0;
	
	Min_dis=Global::num_dim*(Global::boundary.lower-Global::boundary.upper)*(Global::boundary.lower-Global::boundary.upper);
	Min_dis=sqrt(Min_dis);
	for(int i=0;i<popsize;i++){
		if(i==idx) continue;
		double d;
		if(!pbest_to_pbest)
			d=pop[idx].pself.Distance(pop[i].pbest.x);
		else
			d=pop[idx].pbest.Distance(pop[i].pbest.x);

		if(d<Min_dis){
			Min_dis=d;
			index=i;
		}
	}

	return index;
}
void CSwarm::Update_Index(){
 for(int i=0;i<popsize;i++)
	 pop[i].index=i;
}



void CSwarm::Clear_Optima_Lst(){
	CSwarm::converge_optima->Clear();
	CSwarm::non_converge_optima->Clear();
}

void CSwarm::Add_Particle(CSwarm &s){
	if(s.popsize<1) return;
	int old_size=popsize;
	CParticle *t_pop=new CParticle[popsize+s.popsize];

	for(int i=0;i<popsize;i++) t_pop[i]=pop[i];
	
	for(int i=0;i<s.popsize;i++){
		max_ID++;
		t_pop[popsize]=s.pop[i];
		t_pop[popsize].index=popsize;
		t_pop[popsize].ID=max_ID;
		popsize++;
	}
	int pop_size=popsize;
	Clear();
	pop=t_pop;
	popsize=pop_size;
	if(old_size==0)
		Best=pop[Find_PBest()].pbest;
	else
		if(!Best.Better(pop[Find_PBest()].pbest)) Best=pop[Find_PBest()].pbest;

	Update_Cur_Radius();
	initial_radius=initial_radius>s.initial_radius?initial_radius:s.initial_radius;

}
void CSwarm::ADD_Particle_In(const int num){
	
	if(num<1) return ;
	CParticle *t_pop=new CParticle[popsize+num];

	for(int i=0;i<popsize;i++) t_pop[i]=pop[i];

	for(int i=0;i<num;i++){
		max_ID++;
		if(cur_radius==0) cur_radius=0.0001;
		t_pop[popsize].Initialization(Best,cur_radius,popsize,max_ID);
		popsize++;
	}
	int pop_size=popsize;
	Clear();
	pop=t_pop;
	popsize=pop_size;
	Best=pop[Find_PBest()].pbest;
	Update_Cur_Radius();

}
void CSwarm::Calculate_Initial_Radius(){
	initial_radius=0;
	cur_radius=0;
	if(popsize<2) return;
	
	Update_Cur_Radius();
	initial_radius=cur_radius;
}
void CSwarm::Update_MaxID(){
	int max=pop[0].ID;
	for(int i=1;i<popsize;i++)
		if(max<pop[i].ID) max=pop[i].ID;
	max_ID=max;
}


void CSwarm::Calculate_Center(){
	for(int i=0;i<Global::num_dim;i++)
			center.x[i]=0;
	for(int i=0;i<Global::num_dim;i++){
		for(int j=0;j<popsize;j++)
			center.x[i]+=pop[j].pbest.x[i];
		center.x[i]/=popsize;
	}
	center.Fun_Obj();
	if(center.Better(Best)) Best=center;
}


void CSwarm::Update_Best(const int p,int &fes,int changes,int &g,double **fit,double **relative,double &r_value, double glob){
	for(int j=0;j<Global::num_dim;j++){
			double one_dim=Best.x[j];
			double best=Best.fitness; 
			Best.x[j]=pop[p].pself.x[j];
			Best.Fun_Obj();
			if(!Best.Better(best)){
				Best.x[j]=one_dim;
				Best.fitness=best;
			}
			fes++;
			if(fes>Global::T_Fes)
				return;
			if(fes%CSwarm::global_popsize==0){
				g++;
				Update_Fit_Set(changes,g,fit,relative,CSwarm::global_best->fitness,glob);
			}
			if(fes%Global::sample_frequency==0){
				if(Global::optimization_type==MIN)
					r_value+=(1-glob/CSwarm::global_best->fitness);
				else
					r_value+=(1-CSwarm::global_best->fitness/glob);
			}
			
	}
}
void CSwarm::Local_search(int &fes,int changes,int &g,double **fit,double **relative,double &r_value, double glob){
	if(popsize<1) return;
	CPosition t,p;
	for(int i=0;i<popsize;i++){
		t=pop[i].pself;
		pop[i].PSO_Move(pop[i].pbest.x,Best.x,w,c1,c2);
		if(pop[i].pself.Better(pop[i].pbest)){
			pop[i].pbest=pop[i].pself;
			if(pop[i].pself.Better(Best)) Best=pop[i].pself;
		}
		fes++;
		if(fes>Global::T_Fes) 
			return;
		if(fes%CSwarm::global_popsize==0){
			g++;
			Update_Fit_Set(changes,g,fit,relative,CSwarm::global_best->fitness,glob);
			
		}
		if(fes%Global::sample_frequency==0){
			if(Global::optimization_type==MIN)
				r_value+=(1-glob/CSwarm::global_best->fitness);
			else
				r_value+=(1-CSwarm::global_best->fitness/glob);
		}//&&fabs(pop[i].pself.fitness-t.fitness)>0.01
		if(pop[i].pself.Better(t)) Update_Best(i,fes,changes,g,fit,relative,r_value,glob);
		if(fes>Global::T_Fes) 
			return;
	}
	/*t=Best;
	p=Best;
	for(int i=0;i<3;i++){
		t.Cauchy_Mutation();
		if(t.Better(Best)) Best=t;
		t=p;
		fes++;
		if(fes>Global::T_Fes) 
			return;
		
		if(fes%CSwarm::global_popsize==0){
			g++;
			Update_Fit_Set(changes,g,fit,relative,CSwarm::global_best->fitness,glob);
			
		}
		if(fes%Global::sample_frequency==0){
			if(Global::optimization_type==MIN)
				r_value+=(1-glob/CSwarm::global_best->fitness);
			else
				r_value+=(1-CSwarm::global_best->fitness/glob);
		}
	}
*/
	Calculate_Center();
	Update_Cur_Radius();
	int num=(Global::T_Fes-fes)/CSwarm::global_popsize;
	

	evo_num++;
	w=max_w-(max_w-min_w)*evo_num/(evo_num+num);
	if(w<min_w)
		w=min_w;
	
}
void CSwarm::Global_search(int &fes,int changes,int &g,double **fit,double **relative,double &r_value, double glob){
	if(popsize<1) return;
	for(int i=0;i<popsize;i++){
		int nearest;
		
		if(popsize==1) nearest=i;
		else{
			int idx1=Find_Nearest(i,1);
			int idx2=Find_Nearest(i,0);
			if(pop[idx1].pbest.Better(pop[idx2].pbest))
				nearest=idx1;
			else nearest=idx2;
		}
		
		pop[i].Repel_Move(pop[i].pbest,pop[nearest].pbest,*CSwarm::converge_optima,*CSwarm::non_converge_optima,w,c1,c2);
		if(pop[i].pself.Better(pop[i].pbest)){
		pop[i].pbest=pop[i].pself;
		if(pop[i].pself.Better(Best)) Best=pop[i].pself;
		}
		
		fes++;
		if(fes>Global::T_Fes) 
			return;
		if(fes%CSwarm::global_popsize==0){
			g++;
			Update_Fit_Set(changes,g,fit,relative,CSwarm::global_best->fitness,glob);
		}
		if(fes%Global::sample_frequency==0){
			if(Global::optimization_type==MIN)
				r_value+=(1-glob/CSwarm::global_best->fitness);
			else
				r_value+=(1-CSwarm::global_best->fitness/glob);
		}
		
	}
	evo_num++;
}
