#pragma once
#include "Particle.h"
#include "Global.h"
#include "Group.h"
#include "Local_Optima.h"
#include "Color.h"

#include "Clustering.h"

class CSwarm
{
public:	
	int evo_num;
	bool clustering_done;
	int popsize;  // swarm size
	int max_ID;
	double initial_radius;    
	double cur_radius;
	CPosition Best;  // the best one of swarm
	CPosition Worst;
	CParticle *pop;	 // the population
	Color color;
	CPosition center;
	Cluster *clst;
public:
	 double c1,c2; //accelerators 
	 double w,max_w, min_w;
public:
	static CPosition *global_best; // global best one found by LPSO

	// the total number of swarms
	static int pop_num; 
	static CSwarm *sub_swarm;
	static Local_Optima *non_converge_optima;
	static Local_Optima  *converge_optima;	
	static Local_Optima *pre_optima;
	static int min_local_popsize;
	static int max_local_popsize;
	static int global_popsize;
	
	static bool Overlap_NonCon_Check();

	static void Clear_Optima_Lst();
	static void Add_Pop(CSwarm &w);
	static void Delete_Pop(int index);
public:
	CSwarm(void);
	CSwarm(const int pop_size);
	CSwarm(const Group &g);
	CSwarm(const CSwarm &s);
	void Clear();
	~CSwarm(void);
	void Initial(const int pop_size);
	void Alocate_Memory(const int pop_size);
	

public:
	void Add_Particle(const int num);
	void Add_Particle(const CParticle &p);
	void Add_Particle(const Local_Optima &l);
	void Add_Particle(CSwarm &s);
	void ADD_Particle_In(const int num);

	void Delete_Particle(const int id);
	void Delete_Particle(const int *id,const int num);
	void Over_Crowd_Check();
	void Update_Index();
	void Update_MaxID();
	const int Find_Best(void)const;
	const int Find_PBest(void)const;
	const int  Find_PWorst(void)const;
	int Find_Nearest(int,bool pbest_to_pbest);
	 
	void Update_Cur_Radius(bool flag_pbest=true);

	CSwarm &operator= (const CSwarm &s);
	bool Check_Converge();

	void Calculate_Initial_Radius();
	void Calculate_Center();
	
	void Update_Best(const int p,int &fes,int changes,int &g,double **fit,double **relative,double &r_value, double glob);
	void Local_search(int &fes,int changes,int &g,double **fit,double **relative,double &r_value, double glob);
	void Global_search(int &fes,int changes,int &g,double **fit,double **relative,double &r_value, double glob);

};
