/*==========================================================================
//  Implementation of Generalized Benchmark Generator for Dynamic Problems
//
//  See the details of GDBG in "Generalized Dynamic Benchmark Generator for CEC'2009 
//  Competition on Dynamic Optimization"
//  
//  The GDBG was tested by PSO, the source sodes was implemented by Changhe Li
//
//  If you have any questions about the codes, please contact 
//  Changhe Li at cl160@le.ac.uk
===========================================================================*/


#include "Global.h"
#include "Clustering.h"
#include "Swarm.h"
#include <iostream>
#include "MovingPeak.h"
using namespace std;


void System_Initial(double seed,const int num_dim);

void PSO(double **best_rel_fit,double **best_abs_fit,double **fit,double **relative,int *number_dimension,const int num_run);
void run(double *seed);
void Generate_file_name(char * file);
void Output_result(char * file, double ** fit, double ** relative, double **best_rel_fit,double **best_abs_fit,int *number_dimension);
void Clear_Pre_Environment(CSwarm & cradle);
void Cradle_Initial(CSwarm &cradle);
void Go(int &fes,int i,CSwarm & cradle,double &r_value,double **fit,double **relative,const int num_run);
void Create_LS_Swarm(int cur, int p, CSwarm &cradle,bool flag );



void System_Initial(double seed){
	//srand((unsigned)time(NULL));
	static LGM_mixed urng(seed);//rand()/32768.
	Random::Set(urng);
	Global::num_dim=5;
	Global::boundary.Set_Boundary(0,100);
	MovingPeak::init_peaks();
	Global::optimization_type=MAX;
}

void Output_result(char * file, double ** fit, double ** relative, double **best_rel_fit,double **best_abs_fit,int *number_dimension){

		char name[100];
		strcpy(name,file);
		strcat(name,"_fit.txt");
		ofstream ofit(name);
		
		strcpy(name,file);
		strcat(name,"_relative.txt");
		ofstream orel(name);

		strcpy(name,file);
		strcat(name,"_statistic.txt");
		ofstream osta(name);

		

		for(int i=0;i<Global::num_change;i++){
			for(int j=0;j<=Global::change_frequency/(CSwarm::global_popsize);j++){//number_dimension[i]*20
				ofit<<fit[i][j]/Num_Run<<endl;
				orel<<relative[i][j]/Num_Run<<endl;
			}
		}
		double min,max,std=0,avg_rel=0, avg_abs=0;
		double avg_min=0,avg_max=0;
		for(int i=0;i<Num_Run;i++){
			min=max=best_abs_fit[i][0]; 
			for(int j=0;j<Global::num_change;j++){
				if(min>best_abs_fit[i][j])
					min=best_abs_fit[i][j];
				if(max<best_abs_fit[i][j])
					max=best_abs_fit[i][j];
				avg_rel+=best_rel_fit[i][j];
				avg_abs+=best_abs_fit[i][j];
			}
			avg_min+=min;
			avg_max+=max;
		}
		avg_min/=Num_Run;
		avg_max/=Num_Run;
		avg_abs=avg_abs/(Num_Run*Global::num_change);
		avg_rel=avg_rel/(Num_Run*Global::num_change);
		int success=0;
		for(int i=0;i<Num_Run;i++){
			for(int j=0;j<Global::num_change;j++){
				std+=(best_abs_fit[i][j]-avg_abs)*(best_abs_fit[i][j]-avg_abs);
				if(best_abs_fit[i][j]<0.0001) success++;
			}
		}
		std=sqrt(std/(Num_Run*Global::num_change-1));
		osta<<"avg_min: "<<avg_min<<endl;
		osta<<"avg_max: "<<avg_max<<endl;
		osta<<"avg_mean: "<<avg_abs<<endl;
		osta<<"clst_numpeaks: "<<Global::clst_num_peaks/(double)(Num_Run*Global::num_change)<<endl;
		osta<<"alg_foundpeaks: "<<Global::alg_found_peaks/(double)(Num_Run*Global::num_change)<<endl;
		osta<<"alg_realpeaks: "<<Global::alg_real_peaks/(double)(Num_Run*Global::num_change)<<endl;
		osta<<"std: "<<std<<endl;
		osta<<"success_rate: "<<success/(double)(Num_Run*Global::num_change)<<endl;
		
		ofit.close();
		orel.close();
		osta.close();

		
		for(int i=0;i<Global::num_change;i++){
			delete []fit[i];
			delete []relative[i];
		}
		delete [] fit;
		delete [] relative;
				
}
void Generate_file_name(char * file ){
// the name returned by file, f: function, t: change type, d: dimension, m: the number of peaks or basci functions
	char t1[100],t2[100];

	sprintf(t1,"%d",(int)MovingPeak::vlength);
	strcpy(t2,"_vlength");
	strcat(t2,t1); 

	sprintf(t1,"%d",CSwarm::max_local_popsize);
	strcat(t1,t2);
	strcpy(t2,"_Maxsub");
	strcat(t2,t1);

	sprintf(t1,"%d",Global::num_start_clustering);
    strcat(t1,t2);
	strcpy(t2,"_Sclst");
	strcat(t2,t1);
	
	sprintf(t1,"%d",CSwarm::global_popsize);
	strcat(t1,t2);
	strcpy(t2,"_Pop");
	strcat(t2,t1);

	sprintf(t1,"%d",MovingPeak::number_of_peaks);
	strcat(t1,t2);
	strcpy(t2,"_peak");
	strcat(t2,t1);
	sprintf(t1,"%d",Global::num_dim);
	strcat(t1,t2);
	strcpy(t2,"D");
	strcat(t2,t1);
	
	strcpy(file,t2);
}


void Clear_Pre_Environment(CSwarm & cradle){
	
	
		
	delete CSwarm::converge_optima;
	delete CSwarm::non_converge_optima;

	for( int k=0;k<Global::num_clusters;k++) 
		cradle.clst[k].Clear();
	for(int j=0;j<CSwarm::pop_num;j++){
			CSwarm::Delete_Pop(j);
			j--;
		}
	delete  &cradle;

}
void Cradle_Initial(CSwarm &cradle){
	
	cradle.Initial(CSwarm::global_popsize-CSwarm::pre_optima[0].numbers);
	cradle.Add_Particle(CSwarm::pre_optima[0]);
}

void Create_LS_Swarm(int cur, int p, CSwarm &cradle,bool flag){
// create local search swarms
	if( cradle.clst[cur].numbers<1|| cradle.clst[cur+1].numbers<1) return ;
	int i=0;
	while(i< cradle.clst[cur+1].numbers&&!( cradle.clst[cur+1].group[i]== cradle.clst[cur].group[p])) i++;
	if(i== cradle.clst[cur+1].numbers||cradle.clst[cur+1].group[i].numbers==1) return ;
	if(cur+1==Global::num_clusters-1){
		// create a new local search swarm
		Global::clst_num_peaks++;
		CSwarm *s=new CSwarm( cradle.clst[cur+1].group[i]);
		s->clustering_done=flag;
		CSwarm::Add_Pop(*s);
		int *id=new int[ cradle.clst[cur+1].group[i].numbers];
		for(int j=0;j< cradle.clst[cur+1].group[i].numbers;j++) id[j]= cradle.clst[cur+1].group[i].members[j].ID;
		cradle.Delete_Particle(id, cradle.clst[cur+1].group[i].numbers);
		Local_Optimum lo;
		lo.location= cradle.clst[cur+1].group[i].best;
		lo.radius= cradle.clst[cur+1].group[i].radius;
		lo.clustering_done=flag;
		*CSwarm::non_converge_optima=*CSwarm::non_converge_optima+lo;
		delete [] id;
		return ;
	}
	Create_LS_Swarm(cur+1,i,cradle,flag);
}

void Go(int &fes,int i,CSwarm & cradle,double &r_value,double **fit,double **relative,const int num_run){
	int g=0;
	Update_Fit_Set(i,g,fit,relative,CSwarm::global_best->fitness,MovingPeak::global_max);
	bool flag_first=true;
	while(fes<Global::T_Fes){
		cout<<num_run<<" "<<i<<" "<<CSwarm::non_converge_optima->numbers+CSwarm::converge_optima->numbers<<" "<<fes<<" : "<<CSwarm::global_best->fitness<<" "<<MovingPeak::global_max<<endl;
		if(flag_first)
			cradle.Global_search(fes,i,g,fit,relative,r_value,MovingPeak::global_max);
		else
			cradle.Local_search(fes,i,g,fit,relative,r_value,MovingPeak::global_max);
	
		if(cradle.Best.Better(*CSwarm::global_best)) *CSwarm::global_best=cradle.Best;
		if(fes>Global::T_Fes) 
			return;
	
		if(flag_first&&cradle.popsize>0&&cradle.evo_num>=Global::num_start_clustering){	
			int k;
			for( k=0;k<Global::num_clusters-1;k++)  cradle.clst[k]= cradle.clst[k+1];
			 cradle.clst[k].Initial(cradle.pop,cradle.popsize); 
			 cradle.clst[k].Rough_Clustering();

			// check whether there is the same group in all clusters, if, create a local search swarm 
			for(k=0;k< cradle.clst[0].numbers;k++)
			Create_LS_Swarm(0,k,cradle,true);
		
		}
		if(flag_first&&cradle.popsize==0){
			cradle.evo_num=0;
			flag_first=false;
			for( int k=0;k<Global::num_clusters;k++)  cradle.clst[k].Clear();
			
		}

		for(int k=0;k<CSwarm::pop_num;k++){
			if(!CSwarm::sub_swarm[k].clustering_done)
				CSwarm::sub_swarm[k].Global_search(fes,i,g,fit,relative,r_value,MovingPeak::global_max);
			else 
				CSwarm::sub_swarm[k].Local_search(fes,i,g,fit,relative,r_value,MovingPeak::global_max);

			if(CSwarm::sub_swarm[k].Best.Better(CSwarm::non_converge_optima->optima[k].location))
			CSwarm::non_converge_optima->optima[k].location=CSwarm::sub_swarm[k].Best;
			
			if(CSwarm::sub_swarm[k].Best.Better(*CSwarm::global_best)) 
				*CSwarm::global_best=CSwarm::sub_swarm[k].Best;
			if(fes>Global::T_Fes) 	return;

		}
		while(CSwarm::Overlap_NonCon_Check());
		for(int k=0;k<CSwarm::pop_num;k++)CSwarm::sub_swarm[k].Over_Crowd_Check(); 
		// converge check
		for(int k=0;k<CSwarm::pop_num;k++){	
			if(CSwarm::sub_swarm[k].Check_Converge()){
				Local_Optimum lo;
				lo.location=CSwarm::sub_swarm[k].Best;
				lo.radius=CSwarm::sub_swarm[k].initial_radius;
				*CSwarm::converge_optima=*CSwarm::converge_optima+lo;
				CSwarm::non_converge_optima->Delete_Optimum(k);
				CSwarm::Delete_Pop(k);
				k--;	
			}
		}
	

		if(CSwarm::pop_num==0&&cradle.popsize==0&&(CSwarm::non_converge_optima->numbers+CSwarm::converge_optima->numbers>0)) {
			cradle.Add_Particle(CSwarm::max_local_popsize);	
		}
	}

}

void PSO(double **best_rel_fit,double **best_abs_fit,double **fit,double **relative,int *number_dimension,const int num_run){
	int fes;

	CSwarm::pre_optima=new Local_Optima[1];


	double r_value;
	for(int i=0;i<Global::num_change;i++){
		//CSwarm::global_popsize=Global::num_dim*20;

		Global::T_Fes=Global::change_frequency;
		int max_gen=Global::change_frequency/CSwarm::global_popsize;
		number_dimension[i]=Global::num_dim;
		if(num_run==0){// allocate memory to fit and relative for the first run
			fit[i]=new double[max_gen+1];
			relative[i]=new double[max_gen+1];
			for(int j=0;j<=max_gen;j++){
				fit[i][j]=0;
				relative[i][j]=0;
			}
		}
		
		fes=0;
		r_value=0;
		CSwarm *cradle= new CSwarm();
		Cradle_Initial(*cradle);
		CSwarm::global_best=new CPosition;
		CSwarm::non_converge_optima=new Local_Optima();
		CSwarm::converge_optima= new Local_Optima();

		*CSwarm::global_best=cradle->Best;
		Go(fes,i,*cradle,r_value,fit,relative,num_run);
		
		if(Global::optimization_type==MIN)
			best_rel_fit[num_run][i]=MovingPeak::global_max/CSwarm::global_best->fitness;
		else
			best_rel_fit[num_run][i]=CSwarm::global_best->fitness/MovingPeak::global_max;
		
		
		best_abs_fit[num_run][i]=fabs(CSwarm::global_best->fitness-MovingPeak::global_max);
		best_rel_fit[num_run][i]=best_rel_fit[num_run][i]/(1+r_value/(Global::change_frequency/Global::sample_frequency));
		Global::alg_found_peaks+=CSwarm::non_converge_optima->numbers+CSwarm::converge_optima->numbers;
		
		CSwarm::pre_optima[0]=*CSwarm::converge_optima+*CSwarm::non_converge_optima;
		CPosition p;
		int num_ls=0;
		//best_abs_fit[num_run][i]=0;

		for(int k=0;k<MovingPeak::number_of_peaks;k++ ){
			for(int j=0;j<CSwarm::pre_optima[0].numbers;j++){
				Copy(p.x,MovingPeak::peak[k],Global::num_dim);
				if(p.Distance(CSwarm::pre_optima[0].optima[j].location)<CSwarm::pre_optima[0].optima[j].radius){
					if(MovingPeak::peak[k][Global::num_dim+1]-CSwarm::pre_optima[0].optima[j].location.fitness>=0){
					num_ls++;
					break;
					//best_abs_fit[num_run][i]+=DF1::peak[k][Global::num_dim+1]-CSwarm::pre_optima[0].optima[j].location.fitness;
					}
				}
			
			}
		}
		//if(num_ls>0)	best_abs_fit[num_run][i]/=num_ls;
		Global::alg_real_peaks+=num_ls;

		delete 	CSwarm::global_best;
		CSwarm::global_best=0;

		Clear_Pre_Environment(*cradle);
		MovingPeak::change_peaks();
		
	}
	
	delete [] CSwarm::pre_optima;

}
void run(double *seed){
	//run(function, change_type, number_dimensions, number_peaks, seed, output file, performance mark)
	int *number_dimension=new int[Global::num_change]; // save the number of dimensions of each change
	double **relative=new double*[Global::num_change]; 
	double **fit=new double* [Global::num_change];
	double **best_rel_fit=new double *[Num_Run];
	double **best_abs_fit=new double *[Num_Run];
	for(int i=0;i<Num_Run;i++){
		best_rel_fit[i]=new double[Global::num_change];	
		best_abs_fit[i]=new double[Global::num_change];
	}

	for(int i=0;i<Num_Run;i++){
		System_Initial(seed[i]);
		
		PSO(best_rel_fit,best_abs_fit,fit,relative,number_dimension,i); // call PSO algorithm
		MovingPeak::free_peaks();
	}
	char file[100];
	Generate_file_name(file);// generate output file name
	Output_result(file, fit, relative, best_rel_fit,best_abs_fit,number_dimension);
			
	for(int i=0;i<Num_Run;i++){
		delete [] best_rel_fit[i];
		delete [] best_abs_fit[i];
	}

	delete [] best_rel_fit;
	delete [] best_abs_fit;

	delete [] number_dimension;
}

int main(int argc, char *argv[]){
	srand(17);
	double seed[Num_Run];
	for(int i=0;i<Num_Run;i++)
		seed[i]=(double)rand()/RAND_MAX;
	CSwarm::global_popsize=100;
	CSwarm::max_local_popsize=atoi(argv[1]);
	Global::num_start_clustering=atoi(argv[2]);
	
	MovingPeak::vlength=1.;
	MovingPeak::number_of_peaks=atoi(argv[3]);

	run(seed);

	return 1;
}
