////////////////////////////////////////////////////////////////////
//////// Copy Right 2008 by H Cheng   //////////////////////////////
////////////////////////////////////////////////////////////////////
#include "MRIGA.h"

GA_Shortest :: GA_Shortest()
{
}
int GA_Shortest :: iRandom(int num)
{
	int temp = rand()%num;
	return temp;
}
double GA_Shortest :: dRandom()
{
	double temp = (double)rand()/(double)RAND_MAX;
	return temp;
}

void GA_Shortest ::Step_Init()
{
	//Sin >> Size >> Node >> interval_change >> Step >> Repeat >> mem_Size >> ratio_RI;
    Mutation_rate = 0.1;
}

///////////////////// Initialization ///////////////////
void GA_Shortest ::Init()
{
	int i,j,r,temp,flag,close_mem_id,nextUpdate,toponum;
	double cur_mem_fit[MAX],previous_mem_fit[MAX],close_value;
	int total_gen, Num_gen, num_RI;//, num_eRI;
	int randpt_mem_flag,randpt_in_mem[MAX];
	
    total_gen = Step*interval_change;
    Count = 0;
    num_RI = (int)Size*ratio_RI;
    
    for(r=0;r<total_gen;r++)
       pathcost[r] = 0.0;
       
    for(r=0;r<Repeat;r++)
       wholerun_ave[r] = 0.0;
       
    fin >> Source;
	fin >> Destination;
    
 for(r=0;r<Repeat;r++)
 {    
    for(Num_gen =0; Num_gen < total_gen; Num_gen++)
	{
		if(Num_gen % interval_change == 0) //change occurs if Num_gen != 0
		{
          for(i=0;i<Length;i++)
		  { 
			  for(j=0;j<Length;j++)
				  Connect[i][j] = Cost[i][j] = 0;
		  }
		  for(i=0;i<Node;i++)
		  {
		      for(j=0;j<Node;j++)
			      fin >> Connect[i][j];
		  }
		  for(i=0;i<Node;i++)
		  {
		      for(j=0;j<Node;j++)
			      fin >> Cost[i][j];
		  }
		  
          if(Num_gen == 0)
          {
             srand(Source);
             for(i=0;i<Size+mem_Size;i++) // Initialize the population and memory randomly
		         Population(i);
	         srand(time(0));
	         Fitness_Function();
             Print(Num_gen,r);
             Elitism_Select();	         
	         
	         for(i=0;i<mem_Size;i++)
                 randpt_in_mem[i] = Size+i;	       
             randpt_mem_flag = 1; //True             
                     
             for(i=0;i<mem_Size;i++)
                 cur_mem_fit[i] = Routing[Size+i].fitness;
                 
             nextUpdate=Num_gen+5+iRandom(5);
          }          
        }        
        //if(Num_gen == 1)
           
           
		if(Num_gen>0)
		{
		   Fitness_Function();
           Print(Num_gen,r);        
           for(i=0;i<mem_Size;i++)
           {
               previous_mem_fit[i] = cur_mem_fit[i];
               cur_mem_fit[i] = Routing[Size+i].fitness;
           }
           pre_elitism_indi=cur_elitism_indi;
		   Elitism_Select();
           Elitism_Replace();             
        }
        //Print();
		if(Num_gen != 0 && Num_gen % interval_change == 0) //change occurs
		{
		   Merge();
		   Elitism_Select();
        }           
        if( (Num_gen==nextUpdate) || (Num_gen != 0 && Num_gen % interval_change == 0) ) //time to update
        {
           if(randpt_mem_flag == 1)
           {
              for(i=0;i<mem_Size;i++)
              {
                  if(randpt_in_mem[i]!=0)
                     break;                
              }
              
              if(Num_gen==nextUpdate)
                 Routing[randpt_in_mem[i]]= cur_elitism_indi;
              
              if(Num_gen != 0 && Num_gen % interval_change == 0)
              {
                 Routing[randpt_in_mem[i]]= pre_elitism_indi;
                 Fitness_Individual(randpt_in_mem[i]);
              }
                            
              randpt_in_mem[i] = 0;
              
              randpt_mem_flag = 0;  //False
              for(i=0;i<mem_Size;i++)
              {
                  if(randpt_in_mem[i]!=0)
                  {
                     randpt_mem_flag = 1; //True                
                     break;
                  }
              }
           }
           else // replace most similar memory point according to previous environment
           {
              if(Num_gen==nextUpdate)
              {
                 close_mem_id = Size;
                 close_value = fabs(cur_elitism_indi.fitness-Routing[Size].fitness);
                 for(i=1;i<mem_Size;i++)
                 {
                     if(fabs(cur_elitism_indi.fitness-Routing[Size+i].fitness) < close_value)
                     {
                        close_mem_id = Size+i;
                        close_value = fabs(cur_elitism_indi.fitness-Routing[Size+i].fitness);
                     }                               
                 }
                 if(cur_elitism_indi.fitness > Routing[close_mem_id].fitness)
                    Routing[close_mem_id] = cur_elitism_indi;                                      
              }
              
              if(Num_gen != 0 && Num_gen % interval_change == 0)
              {
                 close_mem_id = Size;
                 close_value = fabs(pre_elitism_indi.fitness-previous_mem_fit[0]);
                 for(i=1;i<mem_Size;i++)
                 {
                     if(fabs(pre_elitism_indi.fitness-previous_mem_fit[i]) < close_value)
                     {
                        close_mem_id = Size+i;
                        close_value = fabs(pre_elitism_indi.fitness-previous_mem_fit[i]);
                     }                               
                 }
                 if(pre_elitism_indi.fitness > previous_mem_fit[close_mem_id-Size])
                 {
                    Routing[close_mem_id] = pre_elitism_indi; 
                    Fitness_Individual(close_mem_id);
                 }
              }
           }
           nextUpdate=Num_gen+5+iRandom(5);
           //update randpt_in_mem's value                      
        }
		Random_Immi(num_RI);
			
	    Tournament_Selection();
	    Crossover();
		Recovery();
		Mutuation();  	
	}
	fin >> toponum;
	Routing_Init();   
 }
 Print_Average(total_gen,1);     
}
//////////////////// Init Population ///////////////////
void GA_Shortest :: TTemp(int chromosome_number)
{
	for(int i=0;i<Node;i++)
	{
		Routing[chromosome_number].chromosome[i] = 0;
		for(int j=0;j<Node;j++)
			Temp_Connect[i][j] = Connect[i][j];
	}
}
/*void GA_Shortest :: Population(int chromosome_number)
{
	int temp,locus; 
	int length=0;
	TTemp(chromosome_number); 
	int T[Length];
	locus=T[length]=Source; 
    length++;
	for(int j=1;j<Node;j++)
	{
		temp = pLocation(locus);
		if(temp != -1)
		{
			T[length]=temp;
            length++;
			Delete_Path(locus);
			locus = temp; 
		}	
		if(temp == Destination)
		{
			int i;
			for(i=0;i<length;i++)
				Routing[chromosome_number].chromosome[i] = T[i];
			Routing[chromosome_number].size = length;
			break;
		}
	}
	if(temp != Destination)
		Population(chromosome_number);
}*/
void GA_Shortest :: Population(int chromosome_number)
{
	int i,temp,locus,length; 
    int T[Length];
	
	do
    {
      length=0;
	  TTemp(chromosome_number);
      locus=T[length]=Source; 
      length++;
	  for(int j=1;j<Node;j++)
	  {
		  temp = pLocation(locus);
		  if(temp != -1)
		  {
			 T[length]=temp;
             length++;
			 Delete_Path(locus);
			 locus = temp; 
		  }	
		  if(temp == Destination)
		  {
			 for(i=0;i<length;i++)
			     Routing[chromosome_number].chromosome[i] = T[i];
			 Routing[chromosome_number].size = length;
			 break;
		  }
	  }
    }while(temp != Destination);
}

int GA_Shortest :: pLocation(int locus)
{
	int temp;
	temp = iRandom(Node);
	if(Temp_Connect[locus][temp] == 0)
		temp = -1;
	return temp;
}

void GA_Shortest :: Delete_Path(int locus)
{
	for(int i=0;i<Node;i++)
	{
		Temp_Connect[i][locus] = Temp_Connect[locus][i] = 0 ;
	}
}
///////////////// Fitness_Function /////////////////////
void GA_Shortest :: Fitness_Function()
{
	double temp;
	for(int i=0;i<Size+mem_Size;i++) //including memory
	{
		temp = 0.0;
        Routing[i].fitness=0.0;
		for(int j=1;j<Routing[i].size;j++)
			temp += Cost[Routing[i].chromosome[j-1]][Routing[i].chromosome[j]];
		Routing[i].fitness += 1/temp;
	}
}
/////////// Fitness_Individual //////
void GA_Shortest :: Fitness_Individual(int chromosome_number)
{
	double temp;
	temp = 0.0;
    Routing[chromosome_number].fitness=0.0;
	for(int j=1;j<Routing[chromosome_number].size;j++)
		temp += Cost[Routing[chromosome_number].chromosome[j-1]][Routing[chromosome_number].chromosome[j]];
	Routing[chromosome_number].fitness += 1/temp;	
}
//////////////// Selection //////////////////////
//////////////// Shuffling Exchange Population ////////////
void GA_Shortest :: Shuffle()
{
	int temp1, temp2;
	for(int i=0; i<Size; i++ ) 
	{
		temp1 = iRandom(Size);
        temp2 = iRandom(Size);
		Exchange(temp1,temp2);
	}
}
void GA_Shortest :: Exchange(int first, int second)
{
	Routing[MAX] = Routing[first];
	Routing[first] = Routing[second];
	Routing[second] = Routing[MAX];
}
void GA_Shortest :: Tournament_Selection()
{
	int i,j;
	Shuffle();
	for(i=0;i<Size/2;i++)
		Max(i,Size/2+i);
	for(i=0;i<Size;i++)
		Routing[i] = Routing[MAX+i];
	Count = 0;
}

void GA_Shortest :: Max(int first,int second)
{
	int temp = iRandom(Size);
	if(Routing[first].fitness >= Routing[second].fitness) 
		Routing[MAX+Count] = Routing[first];
	else
		Routing[MAX+Count] = Routing[second];
	Count++;
	Routing[MAX+Count] = Routing[temp];
	Count++;
}
////////////// Crossover ///////////////////////
void GA_Shortest :: Crossover()
{
	int i;
	Shuffle();
	for(i=0;i<Size/2;i++)
		Crosspoint(i,Size/2+i);
}
void GA_Shortest :: Crosspoinit_Init()
{
	for(int i=0;i<MAX;i++)
		Cross[i].x = Cross[i].y = 0;
}
void GA_Shortest :: Crosspoint(int first,int second)
{
	int num = -1; 
    int sp;
	Crosspoinit_Init(); 
	for(int i=1;i<Routing[first].size-1;i++)
	{
		for(int j=1;j<Routing[second].size-1;j++)
		{
			if(Routing[first].chromosome[i] == Routing[second].chromosome[j])
			{
				num++;
				Cross[num].x =i;
				Cross[num].y =j;
			}
		}
	}
	if(num != -1)
	{
		sp = iRandom(num+1);
		Crossover1(first,second,sp);
		Crossover2(first,second,sp);
		cCrossInit(first,second);
	}
}
////////// Change First /////////
void GA_Shortest :: Crossover1(int first,int second,int crosspoint)
{
	int i;
	int num =0;
	int s1 = Cross[crosspoint].x;
    int s2 = Cross[crosspoint].y;
	for(i=0;i<=s1;i++)
	{
		tRouting[0].chromosome[num] = Routing[first].chromosome[i];
		num++;
	}
	for(i=s2+1;i<Routing[second].size;i++)
	{
		tRouting[0].chromosome[num] = Routing[second].chromosome[i];
		num++;
	}
	tRouting[0].size = num;
}
////////// Change Second //////////
void GA_Shortest :: Crossover2(int first,int second,int crosspoint)
{
	int i;
	int num =0;
	int s1 = Cross[crosspoint].x;
    int s2 = Cross[crosspoint].y;
	for(i=0;i<=s2;i++)
	{
		tRouting[1].chromosome[num] = Routing[second].chromosome[i];
		num++;
	}
	for(i=s1+1;i<Routing[first].size;i++)
	{
		tRouting[1].chromosome[num] = Routing[first].chromosome[i];
		num++;
	}
	tRouting[1].size = num;
}
void GA_Shortest :: cCrossInit(int first,int second)
{
	int i;
	for(i=0;i<Node;i++)
		Routing[first].chromosome[i] = Routing[second].chromosome[i] = 0;
	
	for(i=0;i<tRouting[0].size;i++)
		Routing[first].chromosome[i] = tRouting[0].chromosome[i]; 
	Routing[first].size=tRouting[0].size;
	
	for(i=0;i<tRouting[1].size;i++)
		Routing[second].chromosome[i] = tRouting[1].chromosome[i]; 
	Routing[second].size=tRouting[1].size;
	
	for(i=0;i<Node;i++)
	{
		tRouting[0].chromosome[i]=tRouting[1].chromosome[i]=0;
	}
}
//////////////// Recovery ////////////////////
void GA_Shortest :: Recovery()
{
	int i,j,k;
	int flag = 0; 
    int step=0;
	for(i=0;i<Size;i++)
	{
		for(j=1;j<Routing[i].size;j++)
		{
			for(k=Routing[i].size-2;k>j;k--)
			{
				if(Routing[i].chromosome[j] == Routing[i].chromosome[k]) 
				{
					flag = -1;
					break;
				}
			}
			if(flag == -1)
				break;
		}
		if(flag == -1)
			reCombination(i,j,k);
		flag=0;
	}
}
void GA_Shortest :: reCombination(int number,int first, int second)
{
	int i;
	int temp[Length];
	int num = 0;
	for(i=0;i<=first;i++)
	{
		temp[num] = Routing[number].chromosome[i];
		num ++;
	}
	for(i=second+1;i<Routing[number].size;i++)
	{
		temp[num] = Routing[number].chromosome[i];
		num++;
	}
	Routing[number].size = num;
	for(i=0;i<Node;i++)
		Routing[number].chromosome[i] = 0;
	for(i=0;i<num;i++)
		Routing[number].chromosome[i] = temp[i];
}
///////////////////// Mututation //////////////////////
void GA_Shortest :: Mutuation()
{
	int C,sm;
    int flag;
	double rate=0.0;
	for(int i=0;i<Size;i++)
	{
		rate = dRandom();
		if(rate <= Mutation_rate )
		{
			C = i;
			flag = Routing[C].size;
			sm = iRandom(flag);
			mTTemp(C,sm);
			mPopulation(C,sm);
		}
	}
}
void GA_Shortest :: mTTemp(int chromosome_number,int sm)
{
	int i,j;
	for(i=0;i<Node;i++)
	{
		for(j=0;j<Node;j++)
			Temp_Connect[i][j] = Connect[i][j];
	}
	for(i=0;i<sm;i++)
		Delete_Path(Routing[chromosome_number].chromosome[i]);
	Delete_Path(sm+1);  // delete sm+1
}

void GA_Shortest :: mPopulation(int chromosome_number,int sm)
{
	int temp,locus;
	int length=0;
	int T[Length];
	locus=Routing[chromosome_number].chromosome[sm];  
	for(int j=sm+1;j<Node+sm+1;j++)
	{
		temp = pLocation(locus);
		if(temp != -1)
		{
			T[length]=temp;
            length++;
			Delete_Path(locus);
			locus = temp; 
		}	
		if(temp == Destination)
		{
			int i;
			for(i=sm+1;i<Routing[chromosome_number].size;i++)
				Routing[chromosome_number].chromosome[i] = 0;
			for(i=0;i<length;i++)
				Routing[chromosome_number].chromosome[sm+i+1] = T[i];
			Routing[chromosome_number].size = sm+length+1;
			break;
		}
	}
	if(temp != Destination)
		Population(chromosome_number);
}
////////////// Detect Convergence ///////////
int GA_Shortest ::Convergence()
{
	int flag=0;
	Fitness_Function();
	Tournament_Selection();
	for(int i=1;i<Size;i++)
	{
		if(Routing[0].fitness != Routing[i].fitness) 
		{
				flag++;
				break;
		}
	}
	if(flag != 0)
	{
		Crossover();
		Recovery();
		Mutuation();
	}
	return flag;
}
////////////// Print Shortest Path /////////////
void GA_Shortest :: Print(int num_gen, int r)
{ 
	int i;
    double temp=0.0;
	Routing[MAX]=Routing[0];
	for(int i=1;i<Size;i++)
	{
		if(Routing[i].fitness > Routing[MAX].fitness) 
		   Routing[MAX]=Routing[i];
	}	
	for(int j=1;j<Routing[MAX].size;j++)
			temp += Cost[Routing[MAX].chromosome[j-1]][Routing[MAX].chromosome[j]];
	//fout << temp <<" ";
	pathcost[num_gen]+=temp;
	wholerun_ave[r]+=temp;
}
//////////////// Print Average Value ////////////
void GA_Shortest :: Print_Average(int total_gen_num,int mode)
{
   double temp=0.0;
   int j=0;
   for(int i=0;i<total_gen_num;i++)
   {
       if(i % mode ==0)
       {
          temp=pathcost[i]/Repeat;
          fout << temp <<" ";  
          j++; 
          if(j % 100 ==0)                  
             fout << endl;  
       }       
   }
   fout << endl;
   fout << "The average fitness of the 10 runs:" <<endl;
   for(int i=0;i<Repeat;i++)
   {
       temp=wholerun_ave[i]/total_gen_num;
       fout << temp <<" ";
   }
}
////////////Radnom Immigrants/////////////
void GA_Shortest :: Random_Immi(int numRI)
{
     int worst_id;
     double worst_chromo_fitness[MAX];
     for(int j=0;j<Size;j++)
         worst_chromo_fitness[j]=Routing[j].fitness;
     
     for(int i=0;i<numRI;i++)
     {      
         worst_chromo_fitness[MAX-1]=worst_chromo_fitness[0];
         worst_id=0;
         for(int j=1;j<Size;j++)
         {
             if(worst_chromo_fitness[j]<worst_chromo_fitness[MAX-1])
             {
                worst_chromo_fitness[MAX-1]=worst_chromo_fitness[j];
                worst_id=j;                                                       
             }
         }
         worst_chromo_fitness[worst_id]=100.0;
         Population(worst_id); //replace the worst one with a RI  
         //fout <<"RI";               
     }
}
//////////// Elitism Select /////////////
void GA_Shortest :: Elitism_Select()
{
     int best_id;
     double best_chromo_fitness[2*MAX];
          
     for(int j=0;j<Size;j++)
         best_chromo_fitness[j]=Routing[j].fitness;
     
     //first find the elitism
     best_chromo_fitness[MAX]=best_chromo_fitness[0];
     best_id=0;
     for(int j=1;j<Size;j++)
     {
         if(best_chromo_fitness[j]>best_chromo_fitness[MAX])
         {
            best_chromo_fitness[MAX]=best_chromo_fitness[j];
            best_id=j;                                                       
         }
     }
     cur_elitism_indi=Routing[best_id];   //elitism
     //pre_elitism_indi=cur_elitism_indi;     
}
//////////// Elitism Select /////////////
void GA_Shortest :: Elitism_Replace()
{
     int worst_id;
     double worst_chromo_fitness[2*MAX];
          
     for(int j=0;j<Size;j++)
         worst_chromo_fitness[j]=Routing[j].fitness;
     
     worst_chromo_fitness[MAX]=worst_chromo_fitness[0];
     worst_id=0;
     for(int j=1;j<Size;j++)
     {
         if(worst_chromo_fitness[j]<worst_chromo_fitness[MAX])
         {
            worst_chromo_fitness[MAX]=worst_chromo_fitness[j];
            worst_id=j;                                                       
         }
     }
     Routing[worst_id]=pre_elitism_indi;
     Fitness_Individual(worst_id);	 
}
/////////// Merge Current Population and Memory to Get a New Interim Population //
void GA_Shortest :: Merge()
{
     int best_id;
     double best_chromo_fitness[2*MAX];
          
     for(int j=0;j<Size+mem_Size;j++)
         best_chromo_fitness[j]=Routing[j].fitness;
     
     for(int i=0;i<Size;i++)
     {      
         best_chromo_fitness[MAX]=best_chromo_fitness[0];
         best_id=0;
         for(int j=1;j<Size+mem_Size;j++)
         {
             if(best_chromo_fitness[j]>best_chromo_fitness[MAX])
             {
                best_chromo_fitness[MAX]=best_chromo_fitness[j];
                best_id=j;                                                       
             }
         }
         best_chromo_fitness[best_id]=0.0;
         Routing[MAX+i]=Routing[best_id];
     }
     
     for(int i=0;i<Size;i++)
         Routing[i]=Routing[MAX+i];
}
//////////  Initial Step /////////////////
void GA_Shortest ::Routing_Init()
{
	for(int i=0;i<2*MAX;i++)
	{
		Routing[i].size = 0;
		Routing[i].fitness = 0.0;
		for(int j=0;j<Length;j++)
			Routing[i].chromosome[j] = 0;
	}
}

/////// Main ////////
int main(int argc, char *argv[])
{
	int flag;
    int i,j;
	//srand(time(0));
	//Sin >> Size >> Node >> interval_change >> Step >> Repeat >> mem_Size >> ratio_RI;
	char *inputfile;
    char *outputfile = new char[60];
    
	WhichTopo = atoi(argv[1]);
    Size = atoi(argv[2]);
    Node = atoi(argv[3]);
    interval_change = atoi(argv[4]);
    Step = atoi(argv[5]);
    Repeat = atoi(argv[6]);
    mem_Size = atoi(argv[7]);
    ratio_RI = atof(argv[8]);  
    
    if(WhichTopo == 0)
    { 
       inputfile="TopoWithChange0.in";
       sprintf(outputfile, "MRIGA_CyNPC2_P%d_I%d_TN%d_MS%d_RRI%4.2f.out", Size, interval_change, Step, mem_Size, ratio_RI);
    }    
    else
    {
       if(WhichTopo == 2)
          inputfile="TopoWithChange2.in";
       if(WhichTopo == 3)
          inputfile="TopoWithChange3.in";
       if(WhichTopo == 4)
          inputfile="TopoWithChange4.in";
       sprintf(outputfile, "MRIGA_NPC%d_P%d_I%d_TN%d_MS%d_RRI%4.2f.out", WhichTopo, Size, interval_change, Step, mem_Size, ratio_RI);
    }
    
    fin.open(inputfile);    
    fout.open(outputfile,ios::out);  
	
    GA_Shortest gas;  
	gas.Step_Init();
	gas.Init();
	
	fin.close();
    fout.close();
	return 0;
}
