/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#include "Algorithm.h"

Algorithm::Algorithm():m_dimNumber(Global::g_dimNumber){
    //ctor
    ma_name[0]='\0';
    m_algID=-1;
}

Algorithm::~Algorithm()
{
    //dtor
}
Algorithm::Algorithm(AlgorithmTag rID, char *rName):m_algID(rID),m_dimNumber(Global::g_dimNumber){
    if(rName!=0){
            if(strlen(rName)<=MAX_NAME_LENGTH){
                strcpy(ma_name,rName);
            }else{
                Throw(Length_error(rName));
                exit(0);

            }
			Global::g_algNumber=(AlgorithmTag)m_algID;

        }else{

            ma_name[0]='\0';
    }
}
