/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#ifndef ALGORITHM_H
#define ALGORITHM_H
#include <sstream>

#include "../ToolnDef/Global.h"
#include "../ToolnDef/StructDec.h"

extern  string gProName[],gAlgName[];
extern map<string, ProblemTag>gProblem;
extern map<string, AlgorithmTag>gAlgorithm;
extern bool **gAlgPro;
using namespace std;


class Algorithm{
    protected:
        int m_algID;
    public:
        char ma_name[MAX_NAME_LENGTH+1];
        int m_dimNumber;
        stringstream m_algPar;
        Algorithm();
        Algorithm(AlgorithmTag rID, char *name=0);
        virtual ~Algorithm()=0;
        virtual int run(){ return 0;}
        int getID(){return m_algID;}
        void setID(AlgorithmTag rID){
            m_algID=rID;
			Global::g_algNumber=(AlgorithmTag)m_algID;
        }

};

#endif // ALGORITHM_H
