/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 Oct. 2011
// Last modified:
/*
Thomsen R (2004) Multimodal optimization using crowding-based differential evolution. In: Proceedings of
the 2004 IEEE congress on evolutionary computation, pp 1382–1389. IEEE Press, Portland, OR, USA
*/
#ifndef CRDE_H
#define CRDE_H

#include "../DEIndividual.h"
#include "../DEPopulation.h"

class CRDE:public DEPopulation<DEIndividual>
{
    public:
        CRDE(const int rSize);
        virtual ~CRDE();
        int run();
        int evolve();

    protected:
    private:
		
};

#endif // CRDE_H
