/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU Chromosomeral Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 September 2011
// Last modified:
#ifndef DEINDIVIDUAL_H
#define DEINDIVIDUAL_H
#include "../Individual.h"
#include "../Optima.h"

class DEIndividual: public Individual
{
    public:
        DEIndividual();
        virtual ~DEIndividual();

        Chromosome m_pv,m_pu;    // donor vector and trial vector, respectively.

        int m_flag;
    public:
        DEIndividual( DEIndividual &p);
        DEIndividual & operator=(DEIndividual &other);
        virtual void initialize(bool mode=true);
        virtual void initialize(const int idex,const int id,bool mode=true);
        virtual void initialize( Chromosome &p,const int idex,const int id);
		virtual void initialize(int rIdx,int rID,PopInitMethod rMethod, int rPopsize,bool mode=true );
		virtual void initialize(Chromosome &p,double radius, const int ridex,const int rid,bool mode=true);
		void increaseDimension();
		void decreaseDimension();

    public:
        virtual void mutate(float F, Chromosome *r1,  Chromosome *r2,  Chromosome *r3, Chromosome *r4=0,  Chromosome *r5=0);
        virtual void recombine(float CR);
        void select();
};

#endif // DEINDIVIDUAL_H
