/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 12 Nov 2011
// Last modified:

#ifndef GAINDIVIDUAL_H
#define GAINDIVIDUAL_H

#include "../Individual.h"


class GAIndividual : public Individual
{
    public:
        GAIndividual();
        virtual ~GAIndividual();
        GAIndividual(const GAIndividual & other);
        GAIndividual&operator=(GAIndividual & rhs);

		void mutate();
		void xover(GAIndividual & mate);

        void setDistribution(double dis);
        void setMutationProbability(double p);
        void setXoverProbability(double p);
        void increaseDimension();
        void decreaseDimension();
		void setMutationStrategy(GAMutationStrategy s);
		void setMutationStep(double step);
    public:
        Chromosome m_backup;            // backup individual for p_self
        double m_fitness;               // fitness of each individual
        double m_distribution;          // distribution for mutation for real-coded encoding
        double m_mutationProb;          // mutation probability
        double m_xoverProb;             //crossover probability
		GAMutationStrategy m_mutationStratey;
		double m_mutationStep;			// mutation step in normal mutation strategy

        static int ms_numMutation;
        static int ms_numXover;
        bool m_flag;

    protected:
        void binaryMutate();
        void polynomialMutate();
		void normalMutate();
        void binaryXover(GAIndividual & mate);
        void realXover(GAIndividual & mate);
        double getDelta(double u, double delta_l, double delta_u);

    private:
};

#endif // GAINDIVIDUAL_H
