/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 11 May 2011
// Last modified:


#ifndef GENE_H
#define GENE_H


#include "../ToolnDef/Global.h"
using namespace std;

template <class T>
class Gene{
    private:
        vector<T> mv_allele;
    public:
        static unsigned int ms_length;
        Encoding m_type;

    public:
        Gene():mv_allele(ms_length){};
        Gene( const Gene &g ):mv_allele(g.mv_allele){};
        //void initialize();

        virtual ~Gene();
        vector<T> & get() const ;
        /// assignment operator
        Gene & operator=(const Gene &g);
        /// equal operator
        bool operator==(const Gene &g);
        /// not equal operator
        bool operator!=(const Gene &g);

        T &operator[](const int i=0){
            return mv_allele[i];
        }

};

template <class T>
unsigned int Gene<T>::ms_length=1;

template <class T>
Gene<T>::~Gene(){
    //cout<<"gene destructor"<<endl;
    mv_allele.clear();
};
template <class T>
vector<T> &  Gene<T>::get() const {
    return mv_allele;
}
/// assignment operator
template <class T>
Gene<T> &  Gene<T>::operator=(const Gene<T> &g){
    if(this==&g) return *this;

    for(unsigned int i=0;i<ms_length;i++)    mv_allele[i]=g.mv_allele[i];

    return *this;
}

/// equal operator
template <class T>
bool  Gene<T>::operator==(const Gene<T> &g){
    bool flag=true;
    for(unsigned int i=0;i<ms_length;i++){
        if(mv_allele[i]!=g.mv_allele[i]){
            flag=false;
            break;
        }

    }

    return flag;
}

/// not equal operator
template <class T>
bool  Gene<T>::operator!=(const Gene<T> &g){
	bool flag=false;
    for(unsigned int i=0;i<ms_length;i++){
        if(mv_allele[i]!=g.mv_allele[i]){
            flag=true;
            break;
        }

    }

    return flag;
}



#endif // GENE_H
