/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 Oct. 2011
// Last modified:

/*
Lung R, Dumitrescu D (2010) Evolutionary swarm cooperative optimization in dynamic environments. Nat Comput Int J 9(1): 83C94
*/
#ifndef ESCA_H
#define ESCA_H


#include "../../../Algorithms/DE/CRDE/CRDE.h"
#include "../../../Algorithms/PSO/StandardGBest/SPSOGBest.h"

class ESCA: public Algorithm
{
    public:
        ESCA(const int rSize);
        virtual ~ESCA();
		int run();
		void setPara(float rTheta, int rSigma);
		int evolve();
		void changeDimension();
		void updateMemory();
    protected:
		void updateBuffer(Population<Individual>*pso,Population<Individual> *de1,Population<Individual> *de2);
    private:
        SPSOGBest *mp_swarm;
        CRDE *mp_mCRDE,*mp_CRDE;
		float m_theta;
		int m_sigma;


};

#endif // ESCA_H
