/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 31 AUG 2011
// Last modified:
#ifndef OPTIMA_H
#define OPTIMA_H

#include "Chromosome.h"

class Optimum{

public:
Chromosome m_location;
double m_radius;

public:
	Optimum():m_radius(0){
	}
	Optimum(const Optimum &l ): m_location(l.m_location),m_radius(l.m_radius){};
	Optimum(Chromosome & chr, double radius):m_location(chr),m_radius(radius){};
	~Optimum(){}
	Optimum &operator =( Optimum & l){
		if(this==&l) return *this;
		m_location=l.m_location;
		m_radius=l.m_radius;
		return *this;
	}
	Chromosome & getLocation(){
        return m_location;
	}
};


class Optima{
    public:
        Optimum *mp_optima;
        int m_number;

     public:
        Optima();
        Optima(const int num);
        Optima(const Optima & l);
        ~Optima();
        void alocateMemory(const int num);
        void freeMemory();
        Optima * operator+( Optimum & l);
        Optima * operator+( Optima &l);
        Optima & operator=( Optima &l);
        void  deleteOptimum(const int index);
        void updateFitness();
        const Optimum & findBest();
};
#endif // OPTIMA_H
