/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 29 AUG 2011
// Last modified:
/*
Yuhui Shi and Russell Eberhart.
A modiﬁed particle swarm optimizer.
In Proceedings of the IEEE International Conference on Evolutionary
Computation, pages 69–73, Piscataway, NJ, USA, 1998. IEEE Press.
*/
#ifndef PARTICLE_H
#define PARTICLE_H

#include "../Individual.h"
#include "../Optima.h"


struct VMax{
float m_min,m_max;
VMax & operator =(VMax & oth){
	m_min=oth.m_min;m_max=oth.m_max;
	return *this;
}
};
//inertia weight model
class Particle:public Individual{
public:
    Chromosome m_pbest;
	double *mp_vel;
	VMax *mp_vMax;
	int m_flag;

public:
    Particle();
    virtual ~Particle();
    Particle( Particle& other);
	Particle( const Particle& other);
    Particle& operator=(Particle & other);

    void initializeVmax();
    void freeMemory();
    void allocateMemory(const int rSize);


    double getVelocity();
    void initializeVelocity();

    void NormalMutation(double *avg_v);

    virtual void move( Chromosome & lbest ,  Chromosome &gbest,double w, double c1, double c2);

    void moveBound( Chromosome & lbest ,  Chromosome &gbest,double w, double c1, double c2);
    /*void APSO( Chromosome & lbest ,  Chromosome &gbest,double w, double c1,double c2);
    void CPSO(const double *lbest , const double *gbest, int * members, int num, Chromosome &global_bestvoid,double w, double c1, double c2);*/

    virtual void initialize(bool mode=true);
    virtual void initialize(const int idex,const int id,bool mode=true);
    virtual void initialize(Chromosome &p,const int idex,const int id);
    virtual void initialize(Chromosome &p,double radius,const int idex,const int id,bool mode=true);
    virtual void initialize(int rIdx,int rID,PopInitMethod rMethod, int rPopsize,bool mode=true);
    virtual void initialize(Chromosome *w, int mode=1,bool mode2=true);
    virtual void printToFile(ofstream & out);
    Chromosome & getRepresentative();
    void increaseDimension();
    void decreaseDimension();
    void updateMemory();
	void setVmax(float rMin, float rMax);
	void setVmax(float *rMin, float *rMax);
};

#endif // PARTICLE_H
