/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 30 Nov 2011
// Last modified:

/*C. Li,S. Yang, and T. T. Nguyen. A self-learning particle swarm optimizer for 
global optimization problems.IEEE Transactions on Systems, Man, and Cybernetics 
Part B: Cybernetics*/

#ifndef SLSWARM_H
#define SLSWARM_H

#include "SelfLearnParticle.h"
#include "../Swarm.h"


class SLSwarm : public Swarm<SelfLearnParticle>
{
    public:
        int m_numLearnToGbest;
        static int ms_updateFre;
        static double ms_learnRatio;
        static float ms_ratioLearnToGbest;
    public:
        SLSwarm();
        SLSwarm(const int rSize,bool mode=true);
        virtual ~SLSwarm();
        SLSwarm &operator= (SLSwarm &s);
        void updateLearnToGbest();
        int evolve();
        int run();
        void setParameters();
        void updateParameters();
        int getNumLearnTogbest();
        void setNumLearning();
        void calculateNumLearning(const int sfes);
        void MRandToBest( int num);

};

#endif // SLSWARM_H
