/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 29 Nov 2011
// Last modified:
#ifndef SELFLEARNPARTICLE_H
#define SELFLEARNPARTICLE_H

#include "Progress.h"
#include "../Particle.h"


class SelfLearnParticle:public Particle
{
    public:
        SelfLearnParticle();
        virtual ~SelfLearnParticle();
        SelfLearnParticle( SelfLearnParticle& other);
        SelfLearnParticle& operator=( SelfLearnParticle& other);


        virtual void initialize(bool mode=true);
        virtual void initialize(const int idex,const int id,bool mode=true);
        virtual void initialize(Chromosome &p,const int idex,const int id);
        virtual void initialize(Chromosome &p,double radius,const int idex,const int id,bool mode=true);
        virtual void initialize(int rIdx,int rID,PopInitMethod rMethod, int rPopsize,bool mode=true);
        virtual void initialize(Chromosome *w, int mode=1,bool mode2=true);



        void defaultSet();
        void setSelRatio();
        void nonLearnToLearn();
        void learnToNonLearn();
        void updateSelectionRatioMonitor();
        void updateSelectionRatioProg();
        int selectOperator();
        void move(Chromosome &lbest,double w, double c1);

    public:
        //bool m_flag; inherited from Particle , flag of Learning to gbest;
        unsigned int m_itersUnimpr;
        unsigned int m_updateFre;
        double m_learnRatio;

        static  const int ms_numOperators=4;
        Progress *mp_prog;
        Progress *mp_monitor;

    private:
};

#endif // SELFLEARNPARTICLE_H
