/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 September 2011
// Last modified:
#include "ParticleLbest.h"

ParticleLbest::ParticleLbest():Particle()
{


}


ParticleLbest::~ParticleLbest()
{
    //dtor
}


ParticleLbest::ParticleLbest(ParticleLbest &p):Particle(p){

}
ParticleLbest & ParticleLbest::operator =( ParticleLbest &p){
    if(this==&p) return *this;

    Particle::operator=(p);

    return * this;
}

void ParticleLbest::move2007( Chromosome & lbest,double w, double c1, double c2, Chromosome *gbest,bool clamping){

    double u,l;

	for(int j=0;j<Global::g_dimNumber;j++){
		 Global::gp_problem->getSearchRange<double>(l,u,j);

		if(gbest)
		mp_vel[j]=w*mp_vel[j]+c1*Global::gp_uniformAlg->Next()*(lbest.getGene<double>(j)-m_pself.getGene<double>(j))+c2*Global::gp_uniformAlg->Next()*(gbest->getGene<double>(j)-m_pself.getGene<double>(j));
		else
		mp_vel[j]=w*mp_vel[j]+c1*Global::gp_uniformAlg->Next()*(lbest.getGene<double>(j)-m_pself.getGene<double>(j));
		m_pself.getGene<double>(j)=m_pself.getGene<double>(j)+mp_vel[j];
		if(clamping){
			if(m_pself.getGene<double>(j)>u) {
				m_pself.getGene<double>(j)=u;
				mp_vel[j]=0;
			}else if(m_pself.getGene<double>(j)<l ){
				m_pself.getGene<double>(j)=l;
				mp_vel[j]=0;
			}
		}

	}
	if(clamping) m_pself.evaluate();
	else
	if(m_pself.isValid())	m_pself.evaluate();


}

