/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 September 2011
// Last modified:

/*
SPSO07: C. Maurice, “Standard pso 2007 (spso-07),” http://www.particleswarm.info/Programs.html, 2007.
*/
#ifndef SWARMLBEST_H
#define SWARMLBEST_H

#include "ParticleLbest.h"
#include "../Swarm.h"


class SwarmLBest: public Swarm<ParticleLbest>
{
    public:
        SwarmLBest();
        virtual ~SwarmLBest();
        SwarmLBest(const int rSize,bool mode=true);
        SwarmLBest(SwarmLBest & s);
        int run();
        int evolve();
        void allocateMemory(const int size);
        void freeMemory();

        void initializeLinkInfor();
        int findLbest(const int index);
        SwarmLBest & operator= ( SwarmLBest &s);


    public:
        bool **mpp_linkInfor;
        unsigned int m_impr;
};

#endif // SWARMLBEST_H
