/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:

#ifndef PERFORMSINGLEOBJ_H
#define PERFORMSINGLEOBJ_H

#include <sstream>
#include "../ToolnDef/StructDec.h"
using namespace std;

class PerformSingleObj
{
    public:
        static PerformSingleObj * msp_perf;
        static PerformSingleObj * getPerformSingleObj();
        static void initialize(bool rFlag);
        static void deletePerformSingleObj();

        virtual ~PerformSingleObj();
        PerformSingleObj& operator=(const PerformSingleObj& other);
        double getConvergeSpeed2Best();
        double getConvergeSpeed2GOpt();
        double getConvergeSpeed();
        void getStatInfor(double &mean, double &var, double &worst, double &best);
        double getSucRate();
        double getPerformance();
		double getBestSoFar();
        void record(double rObj, const bool rFlag=true);
        void calculatePerformance();
        void addGOpt(double rGOptObj);
        void setFileName(stringstream &rName);
        void setProgrOutputFlag(bool rFlag);
        void outputResult();
        stringstream m_fileName,m_algPar;

        void setConvgProgMode(ConvgProgeMode rMode);
        void setAlgParameter(stringstream & rPar);
        void resetGOptIndx();
    protected:
        void calculateConvergenceTime();
    private:
        PerformSingleObj(bool rFlag);
        PerformSingleObj();
        double **mpp_data;                                          //best obj value of each sampling record
        double **mpp_gOpt;                                          //obj value of global optima
        int m_gOptIdx;                                              // index of current global optimum in mpp_gOpt
        double m_mean,m_var,m_largest,m_smallest;                   //the mean, variance, largest, smallest value in all runs
        double m_speed2Best,m_speed2gOpt,m_speed;                   // the convergence speed to the algorithm's best, the gOpt, and the fitness decrease/incscrease per evaluation
        double m_performance;                                       // the algorithm's performance
        double m_sucRate;                                           // the success rate of achieving a certain accuracy level
        int m_numEvals2Suc;                                         // the number of evaluations needed to achieve the given succuss rate

        double m_bestSoFar;                                        // the best value since last record
        int **mpp_convergeTime;                                    // the number of fitness evaluations when the algorithm converges
        int m_numRecords;                                          // the number of records needed to be recorded during one run
        int m_numGopts;                                            // the number of global optima during one run
        int m_recordsPerChange;                                    // the number of records per change for DOPs (noted: one change in static optimization probelm)
        int m_numEvals2Converge;                                    // the number of evaluations till the algorithm converges

        bool m_progrOutputFlag;
        ConvgProgeMode m_convgMode;                                 // the mode of the convergence graph
};

#endif // PERFORMSINGLEOBJ_H
