/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 28 September 2011
// Last modified:
/*
    This class is used to record relevant inter-information for algorithms using multiple population methods in DOPs during run time
*/

#ifndef POPULATIONINFORDOP_H
#define POPULATIONINFORDOP_H
#include <vector>
#include <sstream>
using namespace std;

class PopulationInforDOP
{
    struct PopInfor{
        int m_fes, m_numIndis,m_numPops,m_numOptsFound,m_numVisablePeaks;
        float m_avgInitialRadius,m_avgCurRadius,m_largestRadius,m_smallestRadius;
    };
    private:
        PopulationInforDOP();
        vector<PopInfor> *mpv_infor;
        stringstream m_fileName;
		bool m_outputProgFlag;
    public:

        float m_avgOptsFound, m_avgVisablePeaks, m_avgSurvivedPops,m_avgInitialRadius;

        void input(int fes, int numIndis,int numPops,int numOptsFound,int numVisablePeaks,float initialRadius=0,float curRadius=0,float largestRadius=0,float smallestRadius=0);
        void output();
        void setFileName(stringstream &rName);
		void setOutProgFlag(bool rflag);
        virtual ~PopulationInforDOP();

        static PopulationInforDOP * msp_infor;
        static PopulationInforDOP * getPopInfor();
        static void initialize();
        static void deletePerformPopInforDOP();
};

#endif // POPULATIONINFORDOP_H
