/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
/*
R. W. Morrison and K. A. De Jong. A test problem generator for non-stationary
environments, Proc. of the 1999 Congr. on Evol. Comput., pp. 2047-2053, 1999.
*/

// Created: 11 May 2011
// Last modified:

/// TODO: in the current version, peaks willl eventually move to some particular locations.
#ifndef DF1_H
#define DF1_H

#include "DynamicContinuous.h"


class DF1 : public DynamicContinuous
{
private:
	DF1(const int rId, const int rDimNumber, const Encoding rEncoding, const int rNumPeaks);
	bool readData();
	static  DF1 *msp_DF1;
	float m_chaoticScale;
public:
	static  DF1 * getDF1();
	static void deleteDF1();
	static bool isInitialized();
	~DF1();
	virtual double evaluate (double const *gen, bool rFlag=true);
    void setChaoticScale(const float s){
        m_chaoticScale=s;
    }
    static void initialize(int rDim, int rPeaks);
    void reset();
private:
	 int **mpp_direction;
protected:
    double peakFunctionCone (double *gen, int peak_number);
    void initilize();
	double dummyEval (double *gen);
	bool boundCheck(const double x, const double min, const double max );
    void currentPeakCalc (double *gen);
    virtual void  freeMemory();
    virtual void allocateMemory(const int rDimNum, const int rPeaks);

    virtual void randomChange();
    ///TODO the flowing change types are not implemented
    virtual void smallStepChange(){randomChange();};
    virtual void largeStepChange(){randomChange();};
    virtual void recurrentChange(){randomChange();};
    virtual void chaoticChange(){randomChange();};
    virtual void recurrentNoisyChange(){randomChange();};
    virtual void changeDimension(){randomChange();};
    virtual void changeNumPeaks(){randomChange();};

};

#endif // DF1_H
