/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 11 May 2011
// Last modified:

#ifndef DYNAMICCONTINUOUS_H
#define DYNAMICCONTINUOUS_H

#include "DynamicProblem.h"

class DynamicContinuous : public DynamicProblem
{
    protected:
        double *mp_genes;							// real coded solution
 //       int m_numPeaks;						        // number of peaks in Rotation_DBG , number of function in Composition_DBG
        double **mpp_peak;					    	// positions of local or global optima(local optima in Rotation_DBG,
        double **mpp_prePeak;							// global optima of basic function in Composition_DBG)
        double **mpp_initialPeak;				        // save the initial positions
        double *mp_height;							// peak height in Rotation_DBG, height of global optima in Composition_DBG
        double *mp_width;                           // weight value of each basic function in Composition_DBG,  peak width in Rotation_DBG

        ///TODO preHeight and preWidth not considered in current version
        double *mp_preHeight;
        double *mp_preWidth;


        double m_minHeight,m_maxHeight;		// minimum\maximum height of all peaks(local optima) in Rotation_DBG(Composition_DBG)
        double m_heightSeverity;

        double m_minWidth, m_maxWidth;
        double m_widthSeverity;

        double *mp_fit;						    	// objective value of each basic funciton in Composition_DBG, peak height in Rotation_DBG
        double m_globalOptima;				    	// global optima value
        bool *mp_globalOptimaIdx;                      // the index of the global optimal peak

        int m_currentPeak;                         // the peak where the best individual is located
        int m_maxPeaksNumber;                      // the number of heigthest peaks
        double m_currentBest;                      // the objective value of current best individual

        bool *mp_whetherChange;                      // whether peaks change or not
        int m_numChangePeaks;                       // the number of peaks that change
        float m_changePeakRatio;                    // the ratio of changing peaks
        double m_accuracy;                          // the accuracy level

        int m_numVisablePeaks;                      // number of visable peaks, a peak is visable only if no peak is no top of it

    public:
        DynamicContinuous(const int rId, const int rDimNumber, const Encoding rEncoding, const int rNumPeaks);
        virtual ~DynamicContinuous()=0;

        double getGlobalMax()const;
        virtual bool getObjGlobalOpt(double *rObj, int rNumObj=1);
        void printFun( std::ofstream & out);
        const double * const getPeak(const int p) const;
        const double * const* const getAllPeaks()const;
        double getPeakHeight(const int p)const;
        double getPrePeakHeight(const int p)const;
        double getPrePeakWidth(const int p)const;
        const double *const getHeight() const;
        const double *const getPrePeak(const int p)const;
        const bool *const getGlobalOptimaIdx()const;
        int getNumberofGlobalOptPeak()const;
        double getAccuracy();

        void setNumberofChanges(const int n);
        void setNumberofChanges(const float rRatio);

        void setHeightSeverity(const double rS);
        void setWidthSeverity(const double rS);
        DynamicContinuous &operator=(const DynamicContinuous &rDCP);

        void setHeight(const double *h);
        void setPosition(const double * const * const p);//const double **p
        virtual void setWidth(const double w);
        void setAccuracy(double rAcc);
        /// for debug mode
        void printPeak( const int rIdx);
        void printPeaks(ofstream & out);
        bool getKnownFlagGOpt();
        int getNumofVisablePeaks();
        bool isVisable(const int rIdx);

    protected:
        virtual void randomChange(){};
        virtual void smallStepChange(){};
        virtual void largeStepChange(){};
        virtual void recurrentChange(){};
        virtual void chaoticChange(){};
        virtual void recurrentNoisyChange(){};

        virtual void parameterSetting(Problem * rP);
        virtual void  freeMemory();
        virtual void allocateMemory(const int rDimNum, const int rPeaks);

        virtual void changeDimension(){};
        virtual void changeNumPeaks(){};

        void calculateGlobalOptima();
        void updateNumberofChanges();
        void computeNumVisablePeaks();

};

#endif // DYNAMICCONTINUOUS_H
