/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 11 May 2011
// Last modified:
#ifndef ROTATIONDBG_H
#define ROTATIONDBG_H

#include "RealDBG.h"


class RotationDBG : public RealDBG
{
private:												//
	static RotationDBG * msp_rdbg;						// pointer of RotationDBG class, single instance class

	RotationDBG(const int rId, const int rDimNumber, const Encoding rEncoding, const int rNumPeaks,
             const ChangeType rT,float const rChangingRatio, const bool rFlagDimChange,const bool rFlagNumPeakChange);
public:
	virtual ~RotationDBG();
    static RotationDBG* getRotationDBG();
	static void deleteRotationDBG();
	static void initialize(int rDim, int rPeaks,const ChangeType rT,float const rChangingRatio, const bool rFlagDimChange,const bool rFlagNumPeakChange);
    static bool isInitialized();
    void initialize(const ChangeType T,float const rChangingRatio, const bool rFlagDimChange=false,const bool rFlagNumPeakChange=false);

	RotationDBG& operator=(const RotationDBG &);
	virtual void  setWidth(const double w);
	virtual double evaluate( double const * x, bool rFlag=true);

protected:
	virtual void parameterSetting(Problem * rP);
    void widthStandardChange();
	virtual void randomChange();
    virtual void smallStepChange();
    virtual void largeStepChange();
    virtual void recurrentChange();
    virtual void chaoticChange();
    virtual void recurrentNoisyChange();
    virtual void changeDimension();
    virtual void changeNumPeaks();
};

#endif // ROTATIONDBG_H
