/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 20 July 2011
// Last modified:
#ifndef BENCHMARKFUNCTION_H
#define BENCHMARKFUNCTION_H

#include "../Problem.h"
#include "../../ToolnDef/Matrix.h"

class BenchmarkFunction : public Problem
{
    public:
        BenchmarkFunction(const int rId, const int rDimNumber, char *rName=0);
        BenchmarkFunction();
        virtual ~BenchmarkFunction();

        void setTranslation(const double *rTrans);
        void setRotation(const double * const * rRot);
        void setBias(double rBias);
        void setScale(double rScale);
        void setRotationFlag(bool rFlag);
        void setTranlationFlag(bool rFlag);
        void setAccuracy(double rAcc);
        double getAccuracy();

        virtual double evaluate(double const *x, bool rFlag=true);
        virtual double evaluate_(double const *x){return 0.;};
        double * getTranslation();
        Matrix * getRotation();
        int getConditionNumber();
        void setConditionNumber(double rC);

        struct GlobalOpt{
            bool m_knownFlag;
            double *mp_location;
            double m_value;
        }m_globalOpt, m_originalGlobalOpt;
        virtual bool getObjGlobalOpt(double *rOpt, int rNumObj=1);
        bool getKnownFlagGOpt();
    public:
        double *mp_translation;         // shifted optimum positions for f(x)
        bool m_scaleFlag,m_rotationFlag,m_translationFlag,m_biasFlag;
        double m_scale,m_bias,m_accuracy;

        double m_conditionNumber;       // generation ratation matrix for functions with rotation property

        Matrix *mp_rotationMatrix;      // rotation matrix

        virtual void freeMemory();
        virtual void allocateMemory(const int rDim);

        BenchmarkFunction& operator=(const BenchmarkFunction & rBF);

        void zeroTranslation();
        bool isZeroTranslation();
        void transform(double * x);


        virtual void initialize(){};
        virtual bool loadTranslation();
        virtual bool loadRotation();
        virtual void setGlobalOpt();
        virtual void setOriginalGlobalOpt();
};

#endif // BENCHMARKFUNCTION_H
