
/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#include "FAckley.h"

FAckley::FAckley(){
    //ctor
}
FAckley::FAckley(const int rId, const int rDimNumber, char *rName):BenchmarkFunction(rId, rDimNumber, rName){

    setSearchRange<double>(-32.768,32.768);

     initialize();
}
FAckley::FAckley(const int rId, const int rDimNumber, char *rName, double rL, double rU):BenchmarkFunction(rId, rDimNumber, rName){
    setSearchRange<double>(rL,rU);
    initialize();
}
FAckley::FAckley(const int rId, const int rDimNumber, char *rName, double *rL, double *rU):BenchmarkFunction(rId, rDimNumber, rName){

    setSearchRange<double>(rL,rU);
    initialize();
}
FAckley::~FAckley(){
    //dtor
}

void FAckley::initialize(){

    setOriginalGlobalOpt();

    switch(m_id){
        case Ackley: case Ackley_Noisy:
            break;
        case S_Ackley:
            loadTranslation();
            break;
        case R_Ackley:
            setConditionNumber(2);
            loadRotation();
            break;
        case RS_Ackley:
            setConditionNumber(100);
            loadTranslation();
            loadRotation();
            break;
        case RS_Ackley_Bound_CEC05:
            setConditionNumber(100);
            loadTranslation();
            loadRotation();
             setBias(-140);
            break;
        case S_Ackley_CEC08:
            setBias(-140);
            loadTranslation();
            break;
        default:
        Throw(Invalid_argument("Error: please check the problem ID"));
        exit(0);
        break;
    }
    setGlobalOpt();

}
void FAckley::setGlobalOpt(){
    m_globalOpt.m_knownFlag=true;
    gCopy(m_globalOpt.mp_location,mp_translation,m_dimNumber);
    m_globalOpt.m_value=BenchmarkFunction::evaluate(m_globalOpt.mp_location,false);


}


double FAckley::evaluate_(double const *x){

	double s1=0,s2=0;

	if(m_id==Ackley_Noisy){

        double noise;
        for(int i=0;i<m_dimNumber;i++){
            noise=0.01*Global::gp_uniformPro->Next();
            s1+=(x[i]+noise)*(x[i]+noise);
            s2+=cos(2*PI*(x[i]+noise));
        }
	}else{

        for(int i=0;i<m_dimNumber;i++){
		s1+=x[i]*x[i];
		s2+=cos(2*PI*x[i]);
        }
	}

	return -20*exp(-0.2*sqrt(s1/m_dimNumber))-exp(s2/m_dimNumber)+20+E+m_bias;

}
