/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#include "FElliptic.h"

FElliptic::FElliptic(){
    //ctor
}
FElliptic::FElliptic(const int rId, const int rDimNumber, char *rName):BenchmarkFunction(rId, rDimNumber, rName){

    setSearchRange<double>(-100.,100.);

     initialize();
}
FElliptic::FElliptic(const int rId, const int rDimNumber, char *rName, double rL, double rU):BenchmarkFunction(rId, rDimNumber, rName){
    setSearchRange<double>(rL,rU);
    initialize();
}
FElliptic::FElliptic(const int rId, const int rDimNumber, char *rName, double *rL, double *rU):BenchmarkFunction(rId, rDimNumber, rName){

    setSearchRange<double>(rL,rU);
    initialize();
}
FElliptic::~FElliptic(){
    //dtor
}

void FElliptic::initialize(){

    setOriginalGlobalOpt();
    switch(m_id){
        case Elliptic:
            break;
        case RS_Elliptic_CEC05:
            loadTranslation();
            loadRotation();
             setBias(-450);
            break;
        default:
        Throw(Invalid_argument("Error: please check the problem ID"));
        exit(0);
        break;
    }
    setGlobalOpt();

}
void FElliptic::setGlobalOpt(){
    m_globalOpt.m_knownFlag=true;
    gCopy(m_globalOpt.mp_location,mp_translation,m_dimNumber);
    m_globalOpt.m_value=BenchmarkFunction::evaluate(m_globalOpt.mp_location,false);
}


double FElliptic::evaluate_(double const *x){

	double s=0;
	for(int i=0;i< m_dimNumber;i++){
		s+=pow(1e6,double(i)/(m_dimNumber-1))*x[i]*x[i];
	}
    return s+m_bias;
}
