/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#include "FMAX_global1.h"

FMAX_global1::FMAX_global1(){
    //ctor
}
FMAX_global1::FMAX_global1(const int rId,  const int rDim, char *rName):BenchmarkFunction(rId, 1, rName){

    setSearchRange<double>(0,1);

     initialize();
}
FMAX_global1::FMAX_global1(const int rId, char *rName, double rL, double rU):BenchmarkFunction(rId, 1, rName){
    setSearchRange<double>(rL,rU);
    initialize();
}
FMAX_global1::FMAX_global1(const int rId,  char *rName, double *rL, double *rU):BenchmarkFunction(rId, 1, rName){

    setSearchRange<double>(rL,rU);
    initialize();
}
FMAX_global1::~FMAX_global1(){
    //dtor
}


void FMAX_global1::initialize(){
        m_problemType=MAX_OPT;
    setOriginalGlobalOpt();

    setGlobalOpt();

}
void FMAX_global1::setGlobalOpt(){
    m_globalOpt.m_knownFlag=true;
    gCopy(m_globalOpt.mp_location,mp_translation,m_dimNumber);
    for(int i=0;i<m_dimNumber;i++) m_globalOpt.mp_location[i]+=0.5;
    m_globalOpt.m_value=BenchmarkFunction::evaluate(m_globalOpt.mp_location,false);

}
void FMAX_global1::setOriginalGlobalOpt(){
    m_originalGlobalOpt.m_knownFlag=true;
    for(int i=0;i<m_dimNumber;i++) m_originalGlobalOpt.mp_location[i]=0.5;
    m_originalGlobalOpt.m_value=BenchmarkFunction::evaluate(m_originalGlobalOpt.mp_location,false);
}


double FMAX_global1::evaluate_(double const *x){

	return  pow(sin(5*PI*x[0]),6.)+m_bias;

}
