/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#ifndef FMAX_GLOBAL1_H
#define FMAX_GLOBAL1_H

#include "BenchmarkFunction.h"

class FMAX_global1 : public BenchmarkFunction
{
    public:
        FMAX_global1();
        FMAX_global1(const int rId,  const int rDim, char *rName);
        FMAX_global1(const int rId,  char *rName, double rL,double rU);
        FMAX_global1(const int rId,  char *rName, double *rL, double *rU);
        virtual ~FMAX_global1();
    protected:
        void initialize();
        void setGlobalOpt();
        void setOriginalGlobalOpt();
        virtual double evaluate_(double const *x);
    private:
};


#endif // FMAX_GLOBAL1_H
