/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#include "FMAX_global3.h"

FMAX_global3::FMAX_global3(){
    //ctor
}
FMAX_global3::FMAX_global3(const int rId,  const int rDim,  char *rName):BenchmarkFunction(rId, 1, rName){

    setSearchRange<double>(0,1);

     initialize();
}
FMAX_global3::FMAX_global3(const int rId, char *rName, double rL, double rU):BenchmarkFunction(rId, 1, rName){
    setSearchRange<double>(rL,rU);
    initialize();
}
FMAX_global3::FMAX_global3(const int rId,  char *rName, double *rL, double *rU):BenchmarkFunction(rId, 1, rName){

    setSearchRange<double>(rL,rU);
    initialize();
}
FMAX_global3::~FMAX_global3(){
    //dtor
}


void FMAX_global3::initialize(){
        m_problemType=MAX_OPT;
    setOriginalGlobalOpt();

    setGlobalOpt();

}
void FMAX_global3::setGlobalOpt(){
    m_globalOpt.m_knownFlag=false;


}
void FMAX_global3::setOriginalGlobalOpt(){
    m_originalGlobalOpt.m_knownFlag=false;
}


double FMAX_global3::evaluate_(double const *x){

	return pow(sin(5*PI*(pow(x[0],3./4.)-0.05)),6.)+m_bias;

}

