/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#include "FMAX_global5.h"


FMAX_global5::FMAX_global5(){
    //ctor
}
FMAX_global5::FMAX_global5(const int rId,  const int rDim, char *rName):BenchmarkFunction(rId, 2, rName){

    setSearchRange<double>(-6,6);

     initialize();
}
FMAX_global5::FMAX_global5(const int rId, char *rName, double rL, double rU):BenchmarkFunction(rId, 2, rName){
    setSearchRange<double>(rL,rU);
    initialize();
}
FMAX_global5::FMAX_global5(const int rId,  char *rName, double *rL, double *rU):BenchmarkFunction(rId, 2, rName){

    setSearchRange<double>(rL,rU);
    initialize();
}
FMAX_global5::~FMAX_global5(){
    //dtor
}


void FMAX_global5::initialize(){
        m_problemType=MAX_OPT;
    setOriginalGlobalOpt();

    setGlobalOpt();

}
void FMAX_global5::setGlobalOpt(){
    m_globalOpt.m_knownFlag=false;


}
void FMAX_global5::setOriginalGlobalOpt(){
    m_originalGlobalOpt.m_knownFlag=false;
}


double FMAX_global5::evaluate_(double const *x){

   return 200-pow(x[0]*x[0]+x[1]-11,2.)-pow(x[0]+x[1]*x[1]-7,2.)+m_bias;

}

