/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#include "FNoncont_Rastrigin.h"

FNoncont_Rastrigin::FNoncont_Rastrigin(){
    //ctor
}
FNoncont_Rastrigin::FNoncont_Rastrigin(const int rId, const int rDim, char *rName):BenchmarkFunction(rId, rDim, rName){
    setSearchRange<double>(-5.12,5.12);
    initialize();
}
FNoncont_Rastrigin::FNoncont_Rastrigin(const int rId, const int rDim, char *rName, double rL, double rU):BenchmarkFunction(rId, rDim, rName){
    setSearchRange<double>(rL,rU);
    initialize();
}
FNoncont_Rastrigin::FNoncont_Rastrigin(const int rId, const int rDim,   char *rName, double *rL, double *rU):BenchmarkFunction(rId, rDim, rName){

    setSearchRange<double>(rL,rU);
    initialize();
}
FNoncont_Rastrigin::~FNoncont_Rastrigin(){
    //dtor
}

void FNoncont_Rastrigin::initialize(){
    setOriginalGlobalOpt();
    setGlobalOpt();
}

double FNoncont_Rastrigin::evaluate_(double const *x){

    double fit=0;
	double *y=new double[m_dimNumber];
	for(int i=0;i<m_dimNumber;i++){
		if(fabs(x[i])<0.5) y[i]=x[i];
		else {
			double a,b=2*x[i];
			if(b <= 0 && b-(int)b<0.5) a=(int)b;
			else if(b-(int)b<0.5) a=(int)b;
			else a = (int)b + 1;
			y[i]=a/2;
		}
	}
	for(int i=0;i<m_dimNumber;i++){
		fit=fit+y[i]*y[i]-10.*cos(2*PI*y[i])+10.;
	}
	delete [] y;
	y=0;

    return fit+m_bias;

}
