/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#ifndef FNONCONT_RASTRIGIN_H
#define FNONCONT_RASTRIGIN_H

#include "BenchmarkFunction.h"

class FNoncont_Rastrigin : public BenchmarkFunction
{
    public:

        FNoncont_Rastrigin();
        FNoncont_Rastrigin(const int rId, const int rDim, char *rName);
        FNoncont_Rastrigin(const int rId, const int rDim,  char *rName, double rL,double rU);
        FNoncont_Rastrigin(const int rId,  const int rDim, char *rName, double *rL, double *rU);
        virtual ~FNoncont_Rastrigin();
    protected:
        void initialize();
        virtual double evaluate_(double const *x);
    private:
};

#endif // FNONCONT_RASTRIGIN_H
