/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#include "FPenalized_2.h"


FPenalized_2::FPenalized_2(){
    //ctor
}
FPenalized_2::FPenalized_2(const int rId, const int rDimNumber, char *rName):BenchmarkFunction(rId, rDimNumber, rName){

    setSearchRange<double>(-50,50);

     initialize();
}
FPenalized_2::FPenalized_2(const int rId, const int rDimNumber, char *rName, double rL, double rU):BenchmarkFunction(rId, rDimNumber, rName){
    setSearchRange<double>(rL,rU);
    initialize();
}
FPenalized_2::FPenalized_2(const int rId, const int rDimNumber, char *rName, double *rL, double *rU):BenchmarkFunction(rId, rDimNumber, rName){

    setSearchRange<double>(rL,rU);
    initialize();
}
FPenalized_2::~FPenalized_2(){
    //dtor
}


void FPenalized_2::initialize(){
    setOriginalGlobalOpt();
    setGlobalOpt();

}
void FPenalized_2::setGlobalOpt(){
    m_globalOpt.m_knownFlag=true;
    gCopy(m_globalOpt.mp_location,mp_translation,m_dimNumber);
    for(int i=0;i<m_dimNumber;i++) m_globalOpt.mp_location[i]+=m_originalGlobalOpt.mp_location[i];
    m_globalOpt.m_value=BenchmarkFunction::evaluate(m_globalOpt.mp_location,false);

}
void FPenalized_2::setOriginalGlobalOpt(){
    m_originalGlobalOpt.m_knownFlag=true;
    for(int i=0;i<m_dimNumber;i++) m_originalGlobalOpt.mp_location[i]=1.;
    m_originalGlobalOpt.m_value=BenchmarkFunction::evaluate(m_originalGlobalOpt.mp_location,false);
}


double FPenalized_2::evaluate_(double const *x){
	double s=0;
	for(int i=0;i<m_dimNumber-1;i++)
		s+=(x[i]-1)*(x[i]-1)*(1+sin(3*PI*x[i+1])*sin(3*PI*x[i+1]));
	s+=(x[m_dimNumber-1]-1)*(x[m_dimNumber-1]-1)*(1+sin(2*PI*x[m_dimNumber-1])*sin(2*PI*x[m_dimNumber-1]))+sin(3*PI*x[0])*sin(3*PI*x[0]);
	s=s*0.1;
	for(int i=0;i<m_dimNumber;i++)
		s+=u(x[i],5,100,4);

	return s+m_bias;

}
double FPenalized_2::u(double x, double a, double k, double m)const{
	if(x>a) return k*pow(x-a,m);
	else if(x<-a) return k*pow(-x-a,m);
	else return 0;
}

