/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#ifndef FPENALIZED_2_H
#define FPENALIZED_2_H

#include "BenchmarkFunction.h"

class FPenalized_2 : public BenchmarkFunction
{
    public:
        FPenalized_2();
        FPenalized_2(const int rId, const int rDimNumber, char *rName);
        FPenalized_2(const int rId, const int rDimNumber, char *rName, double rL,double rU);
        FPenalized_2(const int rId, const int rDimNumber, char *rName, double *rL, double *rU);
        virtual ~FPenalized_2();
    protected:
        void initialize();
        void setGlobalOpt();
        void setOriginalGlobalOpt();
        double u(double x, double a, double k, double m)const;
        virtual double evaluate_(double const *x);
    private:
};
#endif // FPENALIZED_2_H
