/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#include "FQuartic_Noisy.h"

FQuartic_Noisy::FQuartic_Noisy(){
    //ctor
}
FQuartic_Noisy::FQuartic_Noisy(const int rId, const int rDimNumber, char *rName):BenchmarkFunction(rId, rDimNumber, rName){

    setSearchRange<double>(-1.28,1.28);

     initialize();
}
FQuartic_Noisy::FQuartic_Noisy(const int rId, const int rDimNumber, char *rName, double rL, double rU):BenchmarkFunction(rId, rDimNumber, rName){
    setSearchRange<double>(rL,rU);
    initialize();
}
FQuartic_Noisy::FQuartic_Noisy(const int rId, const int rDimNumber, char *rName, double *rL, double *rU):BenchmarkFunction(rId, rDimNumber, rName){

    setSearchRange<double>(rL,rU);
    initialize();
}
FQuartic_Noisy::~FQuartic_Noisy(){
    //dtor
}
void FQuartic_Noisy::initialize(){
    setOriginalGlobalOpt();

    setGlobalOpt();
    setAccuracy(1.0e-2);

}

double FQuartic_Noisy::evaluate_(double const *x){
   	double fitness=0;
	for(int i=0;i<m_dimNumber;i++){
		fitness+=(i+1)*pow(x[i],4);
	}
	fitness+=Global::gp_uniformPro->Next();

    return fitness+m_bias;

}
