/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 11 May 2011
// Last modified:
#include "FRastrigin.h"

FRastrigin::FRastrigin(){
    //ctor
}
FRastrigin::FRastrigin(const int rId, const int rDimNumber, char *rName):BenchmarkFunction(rId, rDimNumber, rName){

    setSearchRange<double>(-5.12,5.12);

     initialize();
}
FRastrigin::FRastrigin(const int rId, const int rDimNumber, char *rName, double rL, double rU):BenchmarkFunction(rId, rDimNumber, rName){
    setSearchRange<double>(rL,rU);
    initialize();
}
FRastrigin::FRastrigin(const int rId, const int rDimNumber, char *rName, double *rL, double *rU):BenchmarkFunction(rId, rDimNumber, rName){

    setSearchRange<double>(rL,rU);
    initialize();
}
FRastrigin::~FRastrigin(){
    //dtor
}
void FRastrigin::initialize(){
    setOriginalGlobalOpt();
    switch(m_id){
        case Rastrigin: case Rastrigin_Noisy:
            break;
        case S_Rastrigin:
            loadTranslation();
            break;
        case R_Rastrigin:
            setConditionNumber(2);
            loadRotation();
            break;
        case RS_Rastrigin: case RS_Rastrigin_CEC05:
            setConditionNumber(2);
            loadTranslation();
            loadRotation();
            break;
        case S_Rastrigin_CEC05: case S_Rastrigin_CEC08:
            setBias(-330);
            loadTranslation();
            break;
        default:
        Throw(Invalid_argument("Error: please check the problem ID"));
        exit(0);
        break;
    }
    setGlobalOpt();
    setAccuracy(1.0e-2);

}
void FRastrigin::setGlobalOpt(){
    m_globalOpt.m_knownFlag=true;
    gCopy(m_globalOpt.mp_location,mp_translation,m_dimNumber);
    m_globalOpt.m_value=BenchmarkFunction::evaluate(m_globalOpt.mp_location,false);

}


double FRastrigin::evaluate_(double const *x){

	double fit=0;
	if(m_id==Rastrigin_Noisy){
        double noise;
        for(int i=0;i<m_dimNumber;i++){
            noise=0.01*Global::gp_uniformPro->Next();
            fit=fit+(x[i]+noise)*(x[i]+noise)-10.*cos(2*PI*(x[i]+noise))+10.;
        }

	}else{
	    for(int i=0;i<m_dimNumber;i++)
		fit=fit+x[i]*x[i]-10.*cos(2*PI*x[i])+10.;

	}

	return fit+m_bias;


}
