/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 11 May 2011
// Last modified:
#ifndef FRASTRIGIN_H
#define FRASTRIGIN_H

#include "BenchmarkFunction.h"


class FRastrigin : public BenchmarkFunction
{
    public:
        FRastrigin();
        FRastrigin(const int rId, const int rDimNumber, char *rName);
        FRastrigin(const int rId, const int rDimNumber, char *rName, double rL,double rU);
        FRastrigin(const int rId, const int rDimNumber, char *rName, double *rL, double *rU);
        virtual ~FRastrigin();
    protected:
        void initialize();
        void setGlobalOpt();
        virtual double evaluate_(double const *x);
    private:
};

#endif // FRASTRIGIN_H
