/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#include "FRosenbrock.h"

FRosenbrock::FRosenbrock(){
    //ctor
}
FRosenbrock::FRosenbrock(const int rId, const int rDimNumber, char *rName):BenchmarkFunction(rId, rDimNumber, rName){

    setSearchRange<double>(-2.048,2.048);

     initialize();
}
FRosenbrock::FRosenbrock(const int rId, const int rDimNumber, char *rName, double rL, double rU):BenchmarkFunction(rId, rDimNumber, rName){
    setSearchRange<double>(rL,rU);
    initialize();
}
FRosenbrock::FRosenbrock(const int rId, const int rDimNumber, char *rName, double *rL, double *rU):BenchmarkFunction(rId, rDimNumber, rName){

    setSearchRange<double>(rL,rU);
    initialize();
}
FRosenbrock::~FRosenbrock(){
    //dtor
}

void FRosenbrock::initialize(){
    setOriginalGlobalOpt();
    switch(m_id){
        case Rosenbrock:
            break;
        case S_Rosenbrock:
            loadTranslation();
            break;
        case S_Rosenbrock_CEC05: case S_Rosenbrock_CEC08:
            setBias(390);
            loadTranslation();
            break;
        default:
        Throw(Invalid_argument("Error: please check the problem ID"));
        exit(0);
        break;
    }
    setGlobalOpt();
    setAccuracy(1.0e-2);

}
void FRosenbrock::setGlobalOpt(){
    m_globalOpt.m_knownFlag=true;
    gCopy(m_globalOpt.mp_location,mp_translation,m_dimNumber);
    for(int i=0;i<m_dimNumber;i++) m_globalOpt.mp_location[i]+=1.;
    m_globalOpt.m_value=BenchmarkFunction::evaluate(m_globalOpt.mp_location,false);
}

void FRosenbrock::setOriginalGlobalOpt(){
    m_originalGlobalOpt.m_knownFlag=true;
    for(int i=0;i<m_dimNumber;i++) m_originalGlobalOpt.mp_location[i]=1.;
    m_originalGlobalOpt.m_value=BenchmarkFunction::evaluate(m_originalGlobalOpt.mp_location,false);
}


double FRosenbrock::evaluate_(double const *x){

	double fitness=0;
	for(int i=0;i<m_dimNumber-1;i++){
		fitness+=100*(x[i+1]-x[i]*x[i])*(x[i+1]-x[i]*x[i])+(x[i]-1)*(x[i]-1);
	}

	return fitness+m_bias;

}
