/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#ifndef FROSENBROCK_H
#define FROSENBROCK_H

#include "BenchmarkFunction.h"


class FRosenbrock : public BenchmarkFunction
{
    public:
        FRosenbrock();
        FRosenbrock(const int rId, const int rDimNumber, char *rName);
        FRosenbrock(const int rId, const int rDimNumber, char *rName, double rL,double rU);
        FRosenbrock(const int rId, const int rDimNumber, char *rName, double *rL, double *rU);
        virtual ~FRosenbrock();
    protected:
        void initialize();
        void setGlobalOpt();
        void setOriginalGlobalOpt();
        virtual double evaluate_(double const *x);
    private:
};

#endif // FROSENBROCK_H
