/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#ifndef FSCAFFER_F6_H
#define FSCAFFER_F6_H

#include "BenchmarkFunction.h"


class FScaffer_F6 : public BenchmarkFunction
{
    public:

        FScaffer_F6();
        FScaffer_F6(const int rId, const int rDim, char *rName);
        FScaffer_F6(const int rId,  const int rDim, char *rName, double rL,double rU);
        FScaffer_F6(const int rId,  const int rDim, char *rName, double *rL, double *rU);
        virtual ~FScaffer_F6();
    protected:
        void initialize();
        void setGlobalOpt();
        virtual double evaluate_(double const *x);
    private:
};

#endif // FSCAFFER_F6_H
