/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#ifndef FSCHWEFEL_H
#define FSCHWEFEL_H

#include "BenchmarkFunction.h"


class FSchwefel : public BenchmarkFunction
{
    public:
        FSchwefel();
        FSchwefel(const int rId, const int rDimNumber, char *rName);
        FSchwefel(const int rId, const int rDimNumber, char *rName, double rL,double rU);
        FSchwefel(const int rId, const int rDimNumber, char *rName, double *rL, double *rU);
        virtual ~FSchwefel();
    protected:
        void initialize();
        void setGlobalOpt();
        void setOriginalGlobalOpt();
        virtual double evaluate_(double const *x);
    private:
};

#endif // FSCHWEFEL_H
