/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#include "FSchwefel_2_22.h"

FSchwefel_2_22::FSchwefel_2_22(){
    //ctor
}
FSchwefel_2_22::FSchwefel_2_22(const int rId, const int rDimNumber, char *rName):BenchmarkFunction(rId, rDimNumber, rName){

    setSearchRange<double>(-10,10);

     initialize();
}
FSchwefel_2_22::FSchwefel_2_22(const int rId, const int rDimNumber, char *rName, double rL, double rU):BenchmarkFunction(rId, rDimNumber, rName){
    setSearchRange<double>(rL,rU);
    initialize();
}
FSchwefel_2_22::FSchwefel_2_22(const int rId, const int rDimNumber, char *rName, double *rL, double *rU):BenchmarkFunction(rId, rDimNumber, rName){

    setSearchRange<double>(rL,rU);
    initialize();
}
FSchwefel_2_22::~FSchwefel_2_22(){
    //dtor
}

void FSchwefel_2_22::initialize(){

    setOriginalGlobalOpt();

    switch(m_id){
        case Schwefel_2_22: case Schwefel_2_22_Noisy:
            break;
        case S_Schwefel_2_22:
            loadTranslation();
            break;
        case R_Schwefel_2_22:
            setConditionNumber(2);
            loadRotation();
            break;
        case RS_Schwefel_2_22:
            setConditionNumber(2);
            loadTranslation();
            loadRotation();
            break;
        default:
        Throw(Invalid_argument("Error: please check the problem ID"));
        exit(0);
        break;
    }
    setGlobalOpt();

}
void FSchwefel_2_22::setGlobalOpt(){
    m_globalOpt.m_knownFlag=true;
    gCopy(m_globalOpt.mp_location,mp_translation,m_dimNumber);
    m_globalOpt.m_value=BenchmarkFunction::evaluate(m_globalOpt.mp_location,false);

}

double FSchwefel_2_22::evaluate_(double const *x){

    double s1=0,s2=1.;
    if(m_id==Schwefel_2_22_Noisy){
        double noise;
         for(int i=0;i<m_dimNumber;i++){
            noise=0.01*Global::gp_uniformPro->Next();
            s1+=fabs(x[i]+noise);
            s2*=fabs(x[i]+noise);
        }

    }else{
        for(int i=0;i<m_dimNumber;i++){
            s1+=fabs(x[i]);
            s2*=fabs(x[i]);
        }
    }

	return s1+s2+m_bias;


}
